/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.section;

import cc.redpen.model.Section;
import cc.redpen.model.Sentence;
import cc.redpen.validator.Validator;
import java.util.List;

public class HeaderLengthValidator
extends Validator {
    public HeaderLengthValidator() {
        super("max_len", 70, "min_level", 3);
    }

    @Override
    public void validate(Section section) {
        if (section.getLevel() >= this.getInt("min_level")) {
            return;
        }
        List<Sentence> headerContents = section.getHeaderContents();
        int headerLength = headerContents.stream().map(s -> s.getContent().length()).reduce(0, (s, r) -> s + r);
        if (headerLength > this.getInt("max_len")) {
            this.addLocalizedError(section.getJoinedHeaderContents(), this.getInt("max_len"));
        }
    }
}

