/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.section;

import cc.redpen.model.Paragraph;
import cc.redpen.model.Section;
import cc.redpen.model.Sentence;
import cc.redpen.validator.Validator;

public final class SectionLengthValidator
extends Validator {
    public SectionLengthValidator() {
        super("max_num", 1000);
    }

    @Override
    public void validate(Section section) {
        int sectionCharNumber = 0;
        for (Paragraph currentParagraph : section.getParagraphs()) {
            for (Sentence sentence : currentParagraph.getSentences()) {
                sectionCharNumber += sentence.getContent().length();
            }
        }
        if (sectionCharNumber > this.getInt("max_num")) {
            this.addLocalizedError(section.getJoinedHeaderContents(), sectionCharNumber, this.getInt("max_num"));
        }
    }
}

