/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.RedPenException;
import cc.redpen.config.SymbolType;
import cc.redpen.model.Sentence;
import cc.redpen.validator.Validator;

public final class CommaNumberValidator
extends Validator {
    private char comma;

    public CommaNumberValidator() {
        super("max_num", 3);
    }

    private int getMaxNum() {
        return this.getInt("max_num");
    }

    @Override
    public void validate(Sentence sentence) {
        String content = sentence.getContent();
        int commaCount = 0;
        int position = 0;
        while ((position = content.indexOf(this.comma)) != -1) {
            ++commaCount;
            content = content.substring(position + 1, content.length());
        }
        if (this.getMaxNum() < commaCount) {
            this.addLocalizedError(sentence, commaCount, this.getMaxNum());
        }
    }

    @Override
    protected void init() throws RedPenException {
        this.comma = this.getSymbolTable().getValueOrFallbackToDefault(SymbolType.COMMA);
    }
}

