/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.model.Sentence;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.validator.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class ContractionValidator
extends Validator {
    private static final Set<String> contractions = new HashSet<String>();
    private static final Set<String> nonContractions;
    private int foundContractionNum;
    private int foundNonContractionNum;

    @Override
    public List<String> getSupportedLanguages() {
        return Collections.singletonList(Locale.ENGLISH.getLanguage());
    }

    @Override
    public void validate(Sentence sentence) {
        for (TokenElement token : sentence.getTokens()) {
            String surface = token.getSurface().toLowerCase();
            if (this.foundNonContractionNum < this.foundContractionNum || !contractions.contains(surface)) continue;
            this.addLocalizedErrorFromToken(sentence, token);
        }
    }

    @Override
    public void preValidate(Sentence sentence) {
        for (TokenElement token : sentence.getTokens()) {
            String surface = token.getSurface().toLowerCase();
            if (contractions.contains(surface)) {
                ++this.foundContractionNum;
                continue;
            }
            if (!nonContractions.contains(surface)) continue;
            ++this.foundNonContractionNum;
        }
    }

    static {
        contractions.add("aren't");
        contractions.add("can't");
        contractions.add("couldn't");
        contractions.add("didn't");
        contractions.add("doesn't");
        contractions.add("don't");
        contractions.add("hadn't");
        contractions.add("hasn't");
        contractions.add("haven't");
        contractions.add("he'd");
        contractions.add("he'll");
        contractions.add("he's");
        contractions.add("i'd");
        contractions.add("i'll");
        contractions.add("i'm");
        contractions.add("i've");
        contractions.add("isn't");
        contractions.add("it's");
        contractions.add("let's");
        contractions.add("mightn't");
        contractions.add("mustn't");
        contractions.add("shan't");
        contractions.add("she'd");
        contractions.add("she'll");
        contractions.add("she's");
        contractions.add("shouldn't");
        contractions.add("that's");
        contractions.add("there's");
        contractions.add("they'd");
        contractions.add("they'll");
        contractions.add("they're");
        contractions.add("they've");
        contractions.add("we'd");
        contractions.add("we'll");
        contractions.add("we're");
        contractions.add("we've");
        contractions.add("weren't");
        contractions.add("what'll");
        contractions.add("what're");
        contractions.add("what's");
        contractions.add("what've");
        contractions.add("where's");
        contractions.add("who'd");
        contractions.add("who'll");
        contractions.add("who're");
        contractions.add("who's");
        contractions.add("who've");
        contractions.add("won't");
        contractions.add("wouldn't");
        contractions.add("you'd");
        contractions.add("you'll");
        contractions.add("you're");
        contractions.add("you've");
        nonContractions = new HashSet<String>();
        nonContractions.add("are");
        nonContractions.add("cannot");
        nonContractions.add("can");
        nonContractions.add("could");
        nonContractions.add("did");
        nonContractions.add("do");
        nonContractions.add("had");
        nonContractions.add("has");
        nonContractions.add("have");
        nonContractions.add("he");
        nonContractions.add("i");
        nonContractions.add("it");
        nonContractions.add("let");
        nonContractions.add("might");
        nonContractions.add("must");
        nonContractions.add("shall");
        nonContractions.add("she");
        nonContractions.add("that");
        nonContractions.add("there");
        nonContractions.add("we");
        nonContractions.add("what");
        nonContractions.add("who");
        nonContractions.add("will");
        nonContractions.add("would");
        nonContractions.add("you");
        nonContractions.add("they");
    }
}

