/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.RedPenException;
import cc.redpen.model.Sentence;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.validator.ExpressionRule;
import cc.redpen.validator.Validator;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class DoubleNegativeValidator
extends Validator {
    private static final String DEFAULT_RESOURCE_EXPRESSION_PATH = "default-resources/double-negative/double-negative-expression-";
    private static final String DEFAULT_RESOURCE_WORD_PATH = "default-resources/double-negative/double-negative-word-";
    private Set<ExpressionRule> invalidExpressions;
    private Set<String> negativeWords;

    @Override
    public void validate(Sentence sentence) {
        for (ExpressionRule rule : this.invalidExpressions) {
            if (!rule.match(sentence.getTokens())) continue;
            this.addLocalizedError(sentence, rule.toString());
            return;
        }
        int count = 0;
        for (String negativeWord : this.negativeWords) {
            List<TokenElement> tokens = sentence.getTokens();
            for (TokenElement token : tokens) {
                if (token.getSurface().toLowerCase().equals(negativeWord)) {
                    ++count;
                }
                if (count < 2) continue;
                this.addLocalizedErrorFromToken(sentence, token);
                return;
            }
        }
    }

    @Override
    protected void init() throws RedPenException {
        this.invalidExpressions = (Set)RULE.loadCachedFromResource(DEFAULT_RESOURCE_EXPRESSION_PATH + this.getSymbolTable().getLang() + ".dat", "double negative expression rules");
        this.negativeWords = (Set)WORD_LIST_LOWERCASED.loadCachedFromResource(DEFAULT_RESOURCE_WORD_PATH + this.getSymbolTable().getLang() + ".dat", "double negative words");
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Arrays.asList(Locale.JAPANESE.getLanguage(), Locale.ENGLISH.getLanguage());
    }
}

