/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.model.Sentence;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.validator.DictionaryValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DoubledJoshiValidator
extends DictionaryValidator {
    public DoubledJoshiValidator() {
        super("min_interval", 1);
    }

    @Override
    public void validate(Sentence sentence) {
        HashMap counts = new HashMap();
        HashMap<TokenElement, Integer> positions = new HashMap<TokenElement, Integer>();
        Set<String> skipList = this.getSet("list");
        int id = 0;
        for (TokenElement tokenElement : sentence.getTokens()) {
            if (!tokenElement.getTags().get(0).equals("\u52a9\u8a5e") || skipList.contains(tokenElement.getSurface())) continue;
            if (!counts.containsKey(tokenElement.getSurface())) {
                counts.put(tokenElement.getSurface(), new LinkedList());
            }
            ((List)counts.get(tokenElement.getSurface())).add(tokenElement);
            positions.put(tokenElement, id);
            ++id;
        }
        for (String joshi : counts.keySet()) {
            if (((List)counts.get(joshi)).size() < 2) continue;
            TokenElement prev = null;
            for (TokenElement token : (List)counts.get(joshi)) {
                int prevPosition = this.getPosition(prev, positions);
                int currentPosition = this.getPosition(token, positions);
                prev = token;
                if (prevPosition == -1 || currentPosition == -1 || currentPosition - prevPosition > this.getInt("min_interval")) continue;
                this.addLocalizedError(sentence, joshi);
            }
        }
    }

    private int getPosition(TokenElement token, Map<TokenElement, Integer> positions) {
        if (token == null) {
            return -1;
        }
        return positions.get(token);
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Collections.singletonList(Locale.JAPANESE.getLanguage());
    }
}

