/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.RedPenException;
import cc.redpen.model.Sentence;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.validator.DictionaryValidator;
import java.util.HashSet;

public final class DoubledWordValidator
extends DictionaryValidator {
    public DoubledWordValidator() {
        super("doubled-word/doubled-word-skiplist");
        this.addDefaultProperties("min_len", 3);
    }

    @Override
    protected void init() throws RedPenException {
        super.init();
        if (this.getSymbolTable().getLang().equals("ja") && !this.getConfigAttribute("min_len").isPresent()) {
            this.getProperties().put("min_len", 1);
        }
    }

    @Override
    public void validate(Sentence sentence) {
        HashSet<String> surfaces = new HashSet<String>();
        for (TokenElement token : sentence.getTokens()) {
            String word = token.getSurface().toLowerCase();
            if (word.length() >= this.getInt("min_len") && surfaces.contains(word) && !this.inDictionary(word)) {
                this.addLocalizedErrorFromToken(sentence, token);
            }
            surfaces.add(word);
        }
    }
}

