/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.RedPenException;
import cc.redpen.config.SymbolType;
import cc.redpen.model.Sentence;
import cc.redpen.validator.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class EndOfSentenceValidator
extends Validator {
    private char rightSingleQuotation;
    private char rightDoubleQuotation;
    private char period;
    private char questionMark;
    private char exclamationMark;

    @Override
    public List<String> getSupportedLanguages() {
        return Collections.singletonList(Locale.ENGLISH.getLanguage());
    }

    @Override
    public void validate(Sentence sentence) {
        String content = sentence.getContent();
        if (content.length() < 2) {
            return;
        }
        char lastCharacter = content.charAt(content.length() - 1);
        char secondCharacter = content.charAt(content.length() - 2);
        if (!(lastCharacter != this.period && lastCharacter != this.questionMark && lastCharacter != this.exclamationMark || secondCharacter != this.rightSingleQuotation && secondCharacter != this.rightDoubleQuotation)) {
            this.addLocalizedErrorWithPosition(sentence, content.length() - 2, content.length() - 1, String.valueOf(secondCharacter) + lastCharacter);
        }
    }

    @Override
    protected void init() throws RedPenException {
        this.period = this.getSymbolTable().getSymbol(SymbolType.FULL_STOP).getValue();
        this.rightSingleQuotation = this.getSymbolTable().getSymbol(SymbolType.RIGHT_SINGLE_QUOTATION_MARK).getValue();
        this.rightDoubleQuotation = this.getSymbolTable().getSymbol(SymbolType.RIGHT_DOUBLE_QUOTATION_MARK).getValue();
        this.questionMark = this.getSymbolTable().getSymbol(SymbolType.QUESTION_MARK).getValue();
        this.exclamationMark = this.getSymbolTable().getSymbol(SymbolType.EXCLAMATION_MARK).getValue();
    }
}

