/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.config.Symbol;
import cc.redpen.config.SymbolType;
import cc.redpen.model.Sentence;
import cc.redpen.validator.Validator;
import java.util.Set;

public final class InvalidSymbolValidator
extends Validator {
    @Override
    public void validate(Sentence sentence) {
        Set<SymbolType> symbolTypes = this.getSymbolTable().getNames();
        for (SymbolType symbolType : symbolTypes) {
            this.validateSymbol(sentence, symbolType);
        }
    }

    private void validateSymbol(Sentence sentence, SymbolType symbolType) {
        String sentenceStr = sentence.getContent();
        Symbol symbol = this.getSymbolTable().getSymbol(symbolType);
        for (char invalidChar : symbol.getInvalidChars()) {
            this.detectSymbol(sentence, sentenceStr, invalidChar);
        }
    }

    private void detectSymbol(Sentence sentence, String sentenceStr, char invalidChar) {
        int startPosition = sentenceStr.indexOf(invalidChar);
        if (startPosition == -1) {
            return;
        }
        if (invalidChar != '.' || !this.isDigitPeriod(startPosition, sentenceStr)) {
            this.addLocalizedErrorWithPosition(sentence, startPosition, startPosition + 1, Character.valueOf(invalidChar));
        }
    }

    private boolean isDigitPeriod(int startPosition, String sentenceStr) {
        if (startPosition == sentenceStr.length() - 1 || startPosition == 0) {
            return false;
        }
        return Character.isDigit(sentenceStr.charAt(startPosition - 1)) && Character.isDigit(sentenceStr.charAt(startPosition + 1));
    }
}

