/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.model.Sentence;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.validator.DictionaryValidator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class InvalidWordValidator
extends DictionaryValidator {
    public InvalidWordValidator() {
        super("invalid-word/invalid-word");
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Collections.singletonList(Locale.ENGLISH.getLanguage());
    }

    @Override
    public void validate(Sentence sentence) {
        for (TokenElement token : sentence.getTokens()) {
            String word = token.getSurface().toLowerCase();
            if (!this.inDictionary(word)) continue;
            this.addLocalizedErrorFromToken(sentence, token);
        }
    }
}

