/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.model.Sentence;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.validator.DictionaryValidator;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class JapaneseAmbiguousNounConjunctionValidator
extends DictionaryValidator {
    @Override
    public void validate(Sentence sentence) {
        int stackSize = 0;
        LinkedList<String> surfaces = new LinkedList<String>();
        for (TokenElement tokenElement : sentence.getTokens()) {
            List<String> tags = tokenElement.getTags();
            switch (stackSize) {
                case 0: {
                    if (tags.get(0).equals("\u540d\u8a5e")) {
                        surfaces.add(tags.get(6));
                        stackSize = 1;
                    }
                }
                case 1: {
                    if (!tags.get(0).equals("\u52a9\u8a5e") || !tags.get(6).equals("\u306e")) break;
                    surfaces.add(tags.get(6));
                    stackSize = 2;
                    break;
                }
                case 2: {
                    if (tags.get(0).equals("\u540d\u8a5e")) {
                        surfaces.add(tags.get(6));
                        break;
                    }
                    if (tags.get(0).equals("\u52a9\u8a5e") && tags.get(6).equals("\u306e")) {
                        surfaces.add(tags.get(6));
                        stackSize = 3;
                        break;
                    }
                    surfaces.clear();
                    stackSize = 0;
                    break;
                }
                case 3: {
                    if (tags.get(0).equals("\u540d\u8a5e")) {
                        surfaces.add(tags.get(6));
                        break;
                    }
                    String surface = String.join((CharSequence)"", surfaces);
                    if (!this.inDictionary(surface)) {
                        this.addLocalizedError(sentence, surface);
                    }
                    stackSize = 0;
                }
            }
        }
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Collections.singletonList(Locale.JAPANESE.getLanguage());
    }
}

