/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.model.Sentence;
import cc.redpen.validator.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JapaneseAnchorExpressionValidator
extends Validator {
    private final List<Pattern> patternsNumeric = Arrays.asList(Pattern.compile("[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\uff10-\uff19]+\u7ae0"), Pattern.compile("[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\uff10-\uff19]+\u7bc0"));
    private final List<Pattern> patternsNumericZenkaku = Arrays.asList(Pattern.compile("[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d0-9]+\u7ae0"), Pattern.compile("[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d0-9]+\u7bc0"));
    private final List<Pattern> patternsKansuji = Arrays.asList(Pattern.compile("[0-9\uff10-\uff19]+\u7ae0"), Pattern.compile("[0-9\uff10-\uff19]+\u7bc0"));

    public JapaneseAnchorExpressionValidator() {
        super("mode", "numeric");
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Collections.singletonList(Locale.JAPANESE.getLanguage());
    }

    @Override
    public void validate(Sentence sentence) {
        for (Pattern pat : this.patternsOfCurrentMode()) {
            Matcher m = pat.matcher(sentence.getContent());
            while (m.find()) {
                this.addLocalizedError(sentence, m.group(0));
            }
        }
    }

    private List<Pattern> patternsOfCurrentMode() {
        switch (this.getString("mode")) {
            case "numeric": {
                return this.patternsNumeric;
            }
            case "numeric-zenkaku": {
                return this.patternsNumericZenkaku;
            }
            case "kansuji": {
                return this.patternsKansuji;
            }
        }
        throw new RuntimeException(String.format("unknown mode: %s", this.getString("mode")));
    }
}

