/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.model.Sentence;
import cc.redpen.validator.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JapaneseNumberExpressionValidator
extends Validator {
    private final List<Pattern> patternsNumeric = Arrays.asList(Pattern.compile("(?<![\\u4e00-\\u9faf])[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\uff10-\uff19][\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\uff10-\uff19.\uff0e\u301c\u3001]*[\u3064\u306e]"), Pattern.compile("(\u3072\u3068|\u3075\u305f|[\u307f\u3088\u3080\u3084]\u3063|\u3044\u3064|\u3053\u3053\u306e)\u3064"));
    private final List<Pattern> patternsNumericZenkaku = Arrays.asList(Pattern.compile("(?<![\\u4e00-\\u9faf])[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d0-9][\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d0-9.\uff0e\u301c\u3001]*[\u3064\u306e]"), Pattern.compile("(\u3072\u3068|\u3075\u305f|[\u307f\u3088\u3080\u3084]\u3063|\u3044\u3064|\u3053\u3053\u306e)\u3064"));
    private final List<Pattern> patternsKansuji = Arrays.asList(Pattern.compile("[0-9\uff10-\uff19][0-9\uff10-\uff19.\uff0e\u301c\u3001]*[\u3064\u306e]"), Pattern.compile("(\u3072\u3068|\u3075\u305f|[\u307f\u3088\u3080\u3084]\u3063|\u3044\u3064|\u3053\u3053\u306e)\u3064"));
    private final List<Pattern> patternsHiragana = Arrays.asList(Pattern.compile("(?<![\\u4e00-\\u9faf])[\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d0-9\uff10-\uff19][\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d0-9\uff10-\uff19.\uff0e\u301c\u3001]*[\u3064\u306e]"));

    public JapaneseNumberExpressionValidator() {
        super("mode", "numeric");
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Collections.singletonList(Locale.JAPANESE.getLanguage());
    }

    @Override
    public void validate(Sentence sentence) {
        for (Pattern pat : this.patternsOfCurrentMode()) {
            Matcher m = pat.matcher(sentence.getContent());
            while (m.find()) {
                this.addLocalizedError(sentence, m.group(0));
            }
        }
    }

    private List<Pattern> patternsOfCurrentMode() {
        switch (this.getString("mode")) {
            case "numeric": {
                return this.patternsNumeric;
            }
            case "numeric-zenkaku": {
                return this.patternsNumericZenkaku;
            }
            case "kansuji": {
                return this.patternsKansuji;
            }
            case "hiragana": {
                return this.patternsHiragana;
            }
        }
        throw new RuntimeException(String.format("unknown mode: %s", this.getString("mode")));
    }
}

