/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.model.Sentence;
import cc.redpen.validator.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JapaneseStyleValidator
extends Validator {
    private static final Pattern DEARU_PATTERN = Pattern.compile("\u3067\u3042\u308b|\u306e\u3060\u304c|\u3067\u3042\u3063\u305f|\u3042\u308b\u304c|\u3042\u3063\u305f|\u3060\u3063\u305f");
    private static final Pattern DESUMASU_PATTERN = Pattern.compile("\u3067\u3059\u306d|\u3067\u3057\u305f|\u307e\u3057\u305f|\u3067\u3057\u305f\u304c|\u3067\u3057\u305f\u306e\u3067|\u3067\u3059\u306e\u3067|\u3067\u3059\u304c|\u3067\u3059");
    private int dearuCount = 0;
    private int desumasuCount = 0;

    @Override
    public void preValidate(Sentence sentence) {
        this.dearuCount += this.countMatch(sentence, DEARU_PATTERN);
        this.desumasuCount += this.countMatch(sentence, DESUMASU_PATTERN);
    }

    private int countMatch(Sentence sentence, Pattern pattern) {
        String content = sentence.getContent();
        Matcher mat = pattern.matcher(content);
        int count = 0;
        while (mat.find()) {
            ++count;
        }
        return count;
    }

    private int countEndMatch(Sentence sentence, Pattern pattern) {
        String content = sentence.getContent();
        if (content.length() < 2) {
            return 0;
        }
        int count = 0;
        Matcher mat = pattern.matcher(content);
        mat.region(0, content.length() - 2);
        while (mat.find()) {
            ++count;
        }
        return count;
    }

    @Override
    public void validate(Sentence sentence) {
        if (this.dearuCount > this.desumasuCount) {
            this.detectPattern(sentence, DESUMASU_PATTERN);
        } else {
            this.detectPattern(sentence, DEARU_PATTERN);
        }
    }

    private void detectPattern(Sentence sentence, Pattern pattern) {
        Matcher mat = pattern.matcher(sentence.getContent());
        while (mat.find()) {
            this.addLocalizedErrorWithPosition(sentence, mat.start(), mat.end(), mat.group());
        }
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Collections.singletonList(Locale.JAPANESE.getLanguage());
    }
}

