/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.model.Sentence;
import cc.redpen.util.StringUtils;
import cc.redpen.validator.DictionaryValidator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public final class KatakanaEndHyphenValidator
extends DictionaryValidator {
    private static final int DEFAULT_KATAKANA_LIMIT_LENGTH = 3;
    private static final char HYPHEN = '\u30fc';
    private static final char KATAKANA_MIDDLE_DOT = '\u30fb';

    public static boolean isKatakanaEndHyphen(String katakana) {
        return 3 < katakana.length() && katakana.charAt(katakana.length() - 1) == '\u30fc';
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Collections.singletonList(Locale.JAPANESE.getLanguage());
    }

    @Override
    public void validate(Sentence sentence) {
        StringBuilder katakana = new StringBuilder();
        for (int i = 0; i < sentence.getContent().length(); ++i) {
            char c = sentence.getContent().charAt(i);
            if (StringUtils.isKatakana(c) && c != '\u30fb') {
                katakana.append(c);
                continue;
            }
            this.checkKatakanaEndHyphen(sentence, katakana.toString(), i - 1);
            katakana.delete(0, katakana.length());
        }
        this.checkKatakanaEndHyphen(sentence, katakana.toString(), sentence.getContent().length() - 1);
    }

    private void checkKatakanaEndHyphen(Sentence sentence, String katakana, int position) {
        Set<String> customSkipList = this.getSet("list");
        if ((customSkipList.isEmpty() || !customSkipList.contains(katakana)) && KatakanaEndHyphenValidator.isKatakanaEndHyphen(katakana)) {
            this.addLocalizedErrorWithPosition(sentence, position, position + 1, katakana);
        }
    }
}

