/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.RedPenException;
import cc.redpen.model.Sentence;
import cc.redpen.util.LevenshteinDistance;
import cc.redpen.util.StringUtils;
import cc.redpen.validator.DictionaryValidator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class KatakanaSpellCheckValidator
extends DictionaryValidator {
    private static final String DEFAULT_RESOURCE_PATH = "default-resources/katakana";
    private HashMap<String, Integer> dic = new HashMap();
    private Set<String> exceptions = new HashSet<String>();
    private Map<String, Integer> katakanaWordFrequencies = new HashMap<String, Integer>();

    public KatakanaSpellCheckValidator() {
        super("min_ratio", Float.valueOf(0.3f), "min_freq", 5, "max_ignore_len", 3, "disable-default", false);
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Collections.singletonList(Locale.JAPANESE.getLanguage());
    }

    @Override
    public void preValidate(Sentence sentence) {
        StringBuilder katakana = new StringBuilder();
        for (int i = 0; i < sentence.getContent().length(); ++i) {
            char c = sentence.getContent().charAt(i);
            if (StringUtils.isKatakana(c)) {
                katakana.append(c);
                continue;
            }
            String katakanaWord = katakana.toString();
            this.addKatakana(katakanaWord);
            katakana.delete(0, katakana.length());
        }
        if (katakana.length() > 0) {
            this.addKatakana(katakana.toString());
        }
    }

    private void addKatakana(String katakanaWord) {
        if (this.katakanaWordFrequencies.get(katakanaWord) == null) {
            this.katakanaWordFrequencies.put(katakanaWord, 0);
        }
        this.katakanaWordFrequencies.put(katakanaWord, this.katakanaWordFrequencies.get(katakanaWord) + 1);
    }

    @Override
    public void validate(Sentence sentence) {
        StringBuilder katakana = new StringBuilder();
        for (int i = 0; i < sentence.getContent().length(); ++i) {
            char c = sentence.getContent().charAt(i);
            if (StringUtils.isKatakana(c)) {
                katakana.append(c);
                continue;
            }
            this.checkKatakanaSpell(sentence, katakana.toString());
            katakana.delete(0, katakana.length());
        }
        this.checkKatakanaSpell(sentence, katakana.toString());
    }

    private void checkKatakanaSpell(Sentence sentence, String katakana) {
        if (katakana.length() <= this.getInt("max_ignore_len")) {
            return;
        }
        if (this.dic.containsKey(katakana) || this.exceptions.contains(katakana) || this.getSet("list").contains(katakana) || this.katakanaWordFrequencies.get(katakana) != null && this.katakanaWordFrequencies.get(katakana) > this.getInt("min_freq")) {
            return;
        }
        int minLsDistance = Math.round((float)katakana.length() * this.getFloat("min_ratio"));
        boolean found = false;
        for (String key : this.dic.keySet()) {
            if (LevenshteinDistance.getDistance(key, katakana) > minLsDistance) continue;
            found = true;
            this.addLocalizedError(sentence, katakana, key, this.dic.get(key).toString());
        }
        if (!found) {
            this.dic.put(katakana, sentence.getLineNumber());
        }
    }

    @Override
    protected void init() throws RedPenException {
        super.init();
        if (!this.getBoolean("disable-default")) {
            String defaultDictionaryFile = "default-resources/katakana/katakana-spellcheck.dat";
            this.exceptions = (Set)WORD_LIST.loadCachedFromResource(defaultDictionaryFile, "katakana word dictionary");
        }
    }
}

