/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.RedPenException;
import cc.redpen.model.Sentence;
import cc.redpen.validator.DictionaryValidator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LongKanjiChainValidator
extends DictionaryValidator {
    private final String shard = "[\\u4e00-\\u9faf]{%d,}";
    private Pattern pat;

    public LongKanjiChainValidator() {
        super("long-kanji-chain/long-kanji-chain-skiplist");
        this.addDefaultProperties("max_len", 5);
    }

    @Override
    protected void init() throws RedPenException {
        if (this.getSymbolTable().getLang().equals("ja") && !this.getConfigAttribute("max_len").isPresent()) {
            this.getProperties().put("max_len", 5);
        }
        this.pat = Pattern.compile(String.format("[\\u4e00-\\u9faf]{%d,}", this.getInt("max_len") + 1));
    }

    @Override
    public void validate(Sentence sentence) {
        Matcher m = this.pat.matcher(sentence.getContent());
        while (m.find()) {
            String word = m.group(0);
            if (this.inDictionary(word)) continue;
            this.addLocalizedError(sentence, word, word.length());
        }
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Collections.singletonList(Locale.JAPANESE.getLanguage());
    }
}

