/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.RedPenException;
import cc.redpen.model.Sentence;
import cc.redpen.validator.Validator;

public class NumberFormatValidator
extends Validator {
    private static final String DOT_DELIMITERS = ".\u30fb";
    private static final String COMMA_DELIMITERS = "\u3001,";
    private String decimalDelimiters = ".\u30fb";

    public NumberFormatValidator() {
        super("decimal_delimiter_is_comma", false, "ignore_years", true);
    }

    @Override
    protected void init() throws RedPenException {
        super.init();
        this.decimalDelimiters = this.getBoolean("decimal_delimiter_is_comma") ? COMMA_DELIMITERS : DOT_DELIMITERS;
    }

    @Override
    public void validate(Sentence sentence) {
        String text = sentence.getContent();
        String number = "";
        boolean haveNumber = false;
        int startPosition = 0;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (i == text.length() - 1 && DOT_DELIMITERS.indexOf(ch) != -1) break;
            if (Character.isDigit(ch) || haveNumber && (COMMA_DELIMITERS.indexOf(ch) != -1 || DOT_DELIMITERS.indexOf(ch) != -1)) {
                number = number + text.charAt(i);
                if (!haveNumber) {
                    startPosition = i;
                }
                haveNumber = true;
                continue;
            }
            this.validateNumber(sentence, startPosition, number);
            number = "";
            haveNumber = false;
        }
        this.validateNumber(sentence, startPosition, number);
    }

    private void validateNumber(Sentence sentence, int position, String number) {
        if (!number.isEmpty()) {
            boolean isInteger = true;
            String integerPortion = number;
            for (char delimiter : this.decimalDelimiters.toCharArray()) {
                int decimalPosition = number.indexOf(delimiter);
                if (decimalPosition == -1) continue;
                isInteger = false;
                integerPortion = number.substring(0, decimalPosition);
                if (number.indexOf(delimiter, decimalPosition + 1) == -1) break;
                this.addLocalizedErrorWithPosition("TooManyDecimals", sentence, position, position + number.length(), number);
                break;
            }
            if (this.getBoolean("ignore_years") && isInteger && integerPortion.length() == 4) {
                return;
            }
            int sequenceLength = 0;
            int sequenceStart = 0;
            for (int i = 0; i < integerPortion.length(); ++i) {
                char ch = integerPortion.charAt(i);
                if (Character.isDigit(ch)) {
                    if (sequenceStart != 0 && i == integerPortion.length() - 1 && ++sequenceLength > 0 && sequenceLength < 3) {
                        this.addLocalizedErrorWithPosition("UndelimitedSequenceTooShort", sentence, position, position + number.length(), number);
                        break;
                    }
                } else {
                    if (sequenceStart != 0 && sequenceLength > 0 && sequenceLength < 3) {
                        this.addLocalizedErrorWithPosition("UndelimitedSequenceTooShort", sentence, position, position + number.length(), number);
                        break;
                    }
                    sequenceStart = i;
                    sequenceLength = 0;
                }
                if (sequenceLength <= 3) continue;
                this.addLocalizedErrorWithPosition("UndelimitedSequenceTooLong", sentence, position, position + number.length(), number);
                break;
            }
        }
    }
}

