/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.RedPenException;
import cc.redpen.model.Sentence;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.validator.ExpressionRule;
import cc.redpen.validator.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class OkuriganaValidator
extends Validator {
    private static final Set<String> invalidOkurigana;
    private static final Set<ExpressionRule> invalidOkuriganaTokens;

    @Override
    public void validate(Sentence sentence) {
        invalidOkurigana.stream().forEach(value -> {
            int startPosition = sentence.getContent().indexOf((String)value);
            if (startPosition != -1) {
                this.addLocalizedErrorWithPosition(sentence, startPosition, startPosition + value.length(), value);
            }
        });
        for (ExpressionRule rule : invalidOkuriganaTokens) {
            if (!rule.match(sentence.getTokens())) continue;
            this.addLocalizedError(sentence, rule.toString());
        }
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Collections.singletonList(Locale.JAPANESE.getLanguage());
    }

    @Override
    protected void init() throws RedPenException {
    }

    static {
        invalidOkuriganaTokens = new HashSet<ExpressionRule>();
        invalidOkuriganaTokens.add(new ExpressionRule().addElement(new TokenElement("\u5408\u3055", Arrays.asList("\u52d5\u8a5e", "\u81ea\u7acb"), 0)));
        invalidOkuriganaTokens.add(new ExpressionRule().addElement(new TokenElement("\u5408\u3057", Arrays.asList("\u52d5\u8a5e", "\u81ea\u7acb"), 0)));
        invalidOkuriganaTokens.add(new ExpressionRule().addElement(new TokenElement("\u5408\u3059", Arrays.asList("\u52d5\u8a5e", "\u81ea\u7acb"), 0)));
        invalidOkuriganaTokens.add(new ExpressionRule().addElement(new TokenElement("\u5408\u305b", Arrays.asList("\u52d5\u8a5e", "\u81ea\u7acb"), 0)));
        invalidOkurigana = new HashSet<String>();
        invalidOkurigana.add("\u62bc\u3048");
        invalidOkurigana.add("\u6050\u3057");
        invalidOkurigana.add("\u77ed\u304b");
        invalidOkurigana.add("\u8d77\u3089");
        invalidOkurigana.add("\u8d77\u308a");
        invalidOkurigana.add("\u8d77\u308b");
        invalidOkurigana.add("\u8d77\u308c");
        invalidOkurigana.add("\u8d77\u308d");
        invalidOkurigana.add("\u8457\u3044");
        invalidOkurigana.add("\u8457\u308b\u3057\u3044");
        invalidOkurigana.add("\u8a66\u308b");
        invalidOkurigana.add("\u88ab\u3076");
        invalidOkurigana.add("\u7d1b\u308f\u3057\u3044");
        invalidOkurigana.add("\u9006\u3046");
        invalidOkurigana.add("\u6094\u307e");
        invalidOkurigana.add("\u9665\u3044\u308b");
        invalidOkurigana.add("\u6065\u304b\u3057");
        invalidOkurigana.add("\u6065\u3057");
        invalidOkurigana.add("\u8cbb\u3055");
        invalidOkurigana.add("\u8cbb\u3057");
        invalidOkurigana.add("\u8cbb\u3059");
        invalidOkurigana.add("\u8cbb\u305b");
        invalidOkurigana.add("\u8cbb\u305d");
        invalidOkurigana.add("\u6190\u307e");
        invalidOkurigana.add("\u6190\u307f");
        invalidOkurigana.add("\u6190\u3080");
        invalidOkurigana.add("\u751f\u308c");
        invalidOkurigana.add("\u5546\u306a\u3046");
        invalidOkurigana.add("\u6190\u3081");
        invalidOkurigana.add("\u59a8\u306a\u3044");
        invalidOkurigana.add("\u59a8\u308b");
        invalidOkurigana.add("\u6094\u3080");
        invalidOkurigana.add("\u6094\u3081");
        invalidOkurigana.add("\u9032\u308b");
        invalidOkurigana.add("\u9032\u306a\u3044");
        invalidOkurigana.add("\u9032\u308b");
        invalidOkurigana.add("\u52e7\u306a\u3044");
        invalidOkurigana.add("\u7f8e\u3044");
        invalidOkurigana.add("\u8457\u3044");
        invalidOkurigana.add("\u8352\u3089");
        invalidOkurigana.add("\u8003\u308b");
        invalidOkurigana.add("\u8f1d\u3057");
        invalidOkurigana.add("\u9759\u305a");
        invalidOkurigana.add("\u660e\u304b");
        invalidOkurigana.add("\u5fc5\u3089");
        invalidOkurigana.add("\u518d\u305f\u3073");
        invalidOkurigana.add("\u884c\u306a\u3046");
        invalidOkurigana.add("\u8868\u308f");
        invalidOkurigana.add("\u73fe\u308f");
        invalidOkurigana.add("\u8457\u308f");
        invalidOkurigana.add("\u65ad\u308f");
        invalidOkurigana.add("\u7a4d\u308b");
        invalidOkurigana.add("\u805e\u3048");
        invalidOkurigana.add("\u5f53\u308b");
        invalidOkurigana.add("\u843d\u3055");
        invalidOkurigana.add("\u843d\u3057");
        invalidOkurigana.add("\u843d\u3059");
        invalidOkurigana.add("\u843d\u305b");
        invalidOkurigana.add("\u7d42\u308b");
        invalidOkurigana.add("\u679c\u3055");
        invalidOkurigana.add("\u679c\u3057");
        invalidOkurigana.add("\u679c\u3059");
        invalidOkurigana.add("\u679c\u305b");
        invalidOkurigana.add("\u679c\u305d");
        invalidOkurigana.add("\u5e30\u308b");
        invalidOkurigana.add("\u5909\u308b");
        invalidOkurigana.add("\u66ff\u308b");
        invalidOkurigana.add("\u8cb7\u308b");
        invalidOkurigana.add("\u63db\u308b");
        invalidOkurigana.add("\u4e0a\u308b");
        invalidOkurigana.add("\u8cbb\u3059");
        invalidOkurigana.add("\u958b\u3089\u304f");
        invalidOkurigana.add("\u5371\u3044");
        invalidOkurigana.add("\u5371\u304f");
        invalidOkurigana.add("\u751a\u3057");
        invalidOkurigana.add("\u9038\u3059");
        invalidOkurigana.add("\u9038\u3055");
        invalidOkurigana.add("\u9038\u305b");
        invalidOkurigana.add("\u53cd\u3055");
        invalidOkurigana.add("\u53cd\u3057");
        invalidOkurigana.add("\u53cd\u3059");
        invalidOkurigana.add("\u53cd\u305d");
        invalidOkurigana.add("\u61d0\u308d");
        invalidOkurigana.add("\u6065\u304b\u3057");
        invalidOkurigana.add("\u904e\u3059");
    }
}

