/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.model.Sentence;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.validator.Validator;

public class ParenthesizedSentenceValidator
extends Validator {
    private static final String OPEN_PARENS = "(\uff08";
    private static final String CLOSE_PARENS = ")\uff09";

    public ParenthesizedSentenceValidator() {
        super("max_nesting_level", 1, "max_count", 1, "max_length", 3);
    }

    @Override
    public void validate(Sentence sentence) {
        int nestingLevel = 0;
        int subsentenceLength = 0;
        int subsentenceCount = 0;
        for (TokenElement token : sentence.getTokens()) {
            if (token.getSurface().length() == 1) {
                if (OPEN_PARENS.indexOf(token.getSurface().charAt(0)) != -1) {
                    if (++nestingLevel > this.getInt("max_nesting_level")) {
                        this.addLocalizedErrorWithPosition("NestingLevelTooDeep", sentence, token.getOffset(), token.getOffset() + token.getSurface().length(), new Object[0]);
                    }
                } else if (CLOSE_PARENS.indexOf(token.getSurface().charAt(0)) != -1 && (nestingLevel = Math.max(0, nestingLevel - 1)) == 0) {
                    ++subsentenceCount;
                    if (subsentenceLength > this.getInt("max_length")) {
                        this.addLocalizedErrorWithPosition("SubsentenceTooLong", sentence, token.getOffset(), token.getOffset() + token.getSurface().length(), new Object[0]);
                    }
                    subsentenceLength = 0;
                }
            }
            if (nestingLevel <= 0) continue;
            ++subsentenceLength;
        }
        if (subsentenceCount > this.getInt("max_count")) {
            this.addLocalizedError("SubsentenceTooFrequent", sentence, new Object[0]);
        }
    }
}

