/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.RedPenException;
import cc.redpen.config.Symbol;
import cc.redpen.config.SymbolType;
import cc.redpen.model.Sentence;
import cc.redpen.validator.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class QuotationValidator
extends Validator {
    private static final List<String> DEFAULT_EXCEPTION_SUFFIXES = new ArrayList<String>();
    private List<String> exceptionSuffixes = DEFAULT_EXCEPTION_SUFFIXES;
    private Symbol leftSingleQuotationMark;
    private Symbol rightSingleQuotationMark;
    private Symbol leftDoubleQuotationMark;
    private Symbol rightDoubleQuotationMark;
    private char period;

    public QuotationValidator() {
        super("use_ascii", false);
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Collections.singletonList(Locale.ENGLISH.getLanguage());
    }

    @Override
    public void validate(Sentence sentence) {
        this.checkQuotation(sentence, this.leftSingleQuotationMark, this.rightSingleQuotationMark);
        this.checkQuotation(sentence, this.leftDoubleQuotationMark, this.rightDoubleQuotationMark);
    }

    @Override
    protected void init() throws RedPenException {
        this.period = this.getSymbolTable().getValueOrFallbackToDefault(SymbolType.FULL_STOP);
        this.setUseAscii(this.getBoolean("use_ascii"));
    }

    private void setUseAscii(boolean useAscii) {
        if (useAscii) {
            this.leftSingleQuotationMark = new Symbol(SymbolType.LEFT_SINGLE_QUOTATION_MARK, '\'', "", true, false);
            this.rightSingleQuotationMark = new Symbol(SymbolType.RIGHT_SINGLE_QUOTATION_MARK, '\'', "", false, true);
            this.leftDoubleQuotationMark = new Symbol(SymbolType.LEFT_DOUBLE_QUOTATION_MARK, '\"', "", true, false);
            this.rightDoubleQuotationMark = new Symbol(SymbolType.RIGHT_DOUBLE_QUOTATION_MARK, '\"', "", false, true);
        } else {
            this.leftSingleQuotationMark = new Symbol(SymbolType.LEFT_SINGLE_QUOTATION_MARK, '\u2018', "", true, false);
            this.rightSingleQuotationMark = new Symbol(SymbolType.RIGHT_SINGLE_QUOTATION_MARK, '\u2019', "", false, true);
            this.leftDoubleQuotationMark = new Symbol(SymbolType.LEFT_DOUBLE_QUOTATION_MARK, '\u201c', "", true, false);
            this.rightDoubleQuotationMark = new Symbol(SymbolType.RIGHT_DOUBLE_QUOTATION_MARK, '\u201d', "", false, true);
        }
    }

    private void checkQuotation(Sentence sentence, Symbol leftQuotation, Symbol rightQuotation) {
        String sentenceString = sentence.getContent();
        int leftPosition = 0;
        int rightPosition = 0;
        while (leftPosition >= 0 && rightPosition < sentenceString.length()) {
            leftPosition = this.getQuotePosition(sentenceString, leftQuotation.getValue(), rightPosition + 1);
            rightPosition = leftPosition < 0 ? this.getQuotePosition(sentenceString, rightQuotation.getValue(), rightPosition + 1) : this.getQuotePosition(sentenceString, rightQuotation.getValue(), leftPosition + 1);
            if (leftPosition >= 0 && rightPosition < 0) {
                this.addLocalizedError("RightExist", sentence, new Object[0]);
                break;
            }
            if (leftPosition < 0 && rightPosition >= 0) {
                this.addLocalizedError("LeftExist", sentence, new Object[0]);
                break;
            }
            int nextLeftPosition = this.getQuotePosition(sentenceString, leftQuotation.getValue(), leftPosition + 1);
            int nextRightPosition = this.getQuotePosition(sentenceString, leftQuotation.getValue(), leftPosition + 1);
            if (nextLeftPosition < rightPosition && nextLeftPosition > 0) {
                this.addLocalizedError("DoubleRight", sentence, new Object[0]);
            }
            if (nextRightPosition < leftPosition && nextRightPosition > 0) {
                this.addLocalizedError("DoubleLeft", sentence, new Object[0]);
            }
            if (leftPosition > 0 && leftQuotation.isNeedBeforeSpace() && sentenceString.charAt(leftPosition - 1) != ' ') {
                this.addLocalizedError("LeftSpace", sentence, new Object[0]);
            }
            if (rightPosition <= 0 || rightPosition >= sentenceString.length() - 1 || !rightQuotation.isNeedAfterSpace() || sentenceString.charAt(rightPosition + 1) == ' ' || sentenceString.charAt(rightPosition + 1) == this.period) continue;
            this.addLocalizedError("RightSpace", sentence, new Object[0]);
        }
    }

    private int getQuotePosition(String sentenceStr, char quote, int startPosition) {
        int quoteCandidatePosition = startPosition;
        while (startPosition > -1) {
            quoteCandidatePosition = sentenceStr.indexOf(quote, startPosition);
            boolean isFound = this.detectIsFound(sentenceStr, quoteCandidatePosition);
            if (isFound) {
                return quoteCandidatePosition;
            }
            if (quoteCandidatePosition >= 0) {
                startPosition = quoteCandidatePosition + 1;
                continue;
            }
            return -1;
        }
        return quoteCandidatePosition;
    }

    private boolean detectIsFound(String sentenceStr, int startPosition) {
        if (startPosition < 0) {
            return false;
        }
        for (String exceptionSuffix : this.exceptionSuffixes) {
            if (!sentenceStr.startsWith(exceptionSuffix, startPosition + 1)) continue;
            return false;
        }
        return true;
    }

    static {
        DEFAULT_EXCEPTION_SUFFIXES.add("s ");
        DEFAULT_EXCEPTION_SUFFIXES.add("m ");
    }
}

