/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.RedPenException;
import cc.redpen.config.SymbolType;
import cc.redpen.model.Sentence;
import cc.redpen.util.StringUtils;
import cc.redpen.validator.Validator;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpaceBetweenAlphabeticalWordValidator
extends Validator {
    private char leftParenthesis = (char)40;
    private char rightParenthesis = (char)41;
    private char comma = (char)44;
    private final String shard = "[^A-Za-z0-9 !@#$%^&*()_+=\\[\\]\\\\{}|=<>,.{};':\",./<>?\uff08\uff09\uff3b\uff3d\uff5b\uff5d-]";
    private final String word = "[A-Za-z0-9 !@#$%^&*()_+=\\[\\]\\\\{}|=<>,.{};':\",./<>?\uff08\uff09\uff5b\uff5d\uff3b\uff3d-]+";
    private final Pattern pat = Pattern.compile("[^A-Za-z0-9 !@#$%^&*()_+=\\[\\]\\\\{}|=<>,.{};':\",./<>?\uff08\uff09\uff3b\uff3d\uff5b\uff5d-]\\s+([A-Za-z0-9 !@#$%^&*()_+=\\[\\]\\\\{}|=<>,.{};':\",./<>?\uff08\uff09\uff5b\uff5d\uff3b\uff3d-]+)\\s+[^A-Za-z0-9 !@#$%^&*()_+=\\[\\]\\\\{}|=<>,.{};':\",./<>?\uff08\uff09\uff3b\uff3d\uff5b\uff5d-]");

    public SpaceBetweenAlphabeticalWordValidator() {
        super("forbidden", false, "skip_before", "", "skip_after", "");
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Arrays.asList(Locale.JAPANESE.getLanguage(), Locale.CHINESE.getLanguage());
    }

    @Override
    public void validate(Sentence sentence) {
        if (!this.getBoolean("forbidden")) {
            char prevCharacter = ' ';
            int idx = 0;
            for (char character : sentence.getContent().toCharArray()) {
                if (this.notHasWhiteSpaceBeforeLeftParenthesis(prevCharacter, character)) {
                    this.addLocalizedErrorWithPosition("Before", sentence, idx, idx + 1, new Object[0]);
                } else if (this.notHasWhiteSpaceAfterRightParenthesis(prevCharacter, character)) {
                    this.addLocalizedErrorWithPosition("After", sentence, idx, idx + 1, new Object[0]);
                }
                prevCharacter = character;
                ++idx;
            }
        } else {
            Matcher m = this.pat.matcher(sentence.getContent());
            while (m.find()) {
                String word = m.group(1);
                if (word.contains(" ")) continue;
                this.addLocalizedError("Forbidden", sentence, word);
            }
        }
    }

    private boolean notHasWhiteSpaceBeforeLeftParenthesis(char prevCharacter, char character) {
        return !StringUtils.isBasicLatin(prevCharacter) && this.getString("skip_before").indexOf(prevCharacter) == -1 && prevCharacter != this.leftParenthesis && prevCharacter != this.comma && prevCharacter != this.rightParenthesis && this.rightParenthesis != '\uff09' && StringUtils.isBasicLatin(character) && Character.isLetter(character);
    }

    private boolean notHasWhiteSpaceAfterRightParenthesis(char prevCharacter, char character) {
        return !StringUtils.isBasicLatin(character) && this.getString("skip_after").indexOf(character) == -1 && character != this.rightParenthesis && character != this.leftParenthesis && this.leftParenthesis != '\uff08' && character != this.comma && StringUtils.isBasicLatin(prevCharacter) && Character.isLetter(prevCharacter);
    }

    @Override
    protected void init() throws RedPenException {
        this.leftParenthesis = this.getSymbolTable().getSymbol(SymbolType.LEFT_PARENTHESIS).getValue();
        this.rightParenthesis = this.getSymbolTable().getSymbol(SymbolType.RIGHT_PARENTHESIS).getValue();
        this.comma = this.getSymbolTable().getSymbol(SymbolType.COMMA).getValue();
    }
}

