/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.model.Sentence;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.validator.DictionaryValidator;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class StartWithCapitalLetterValidator
extends DictionaryValidator {
    public StartWithCapitalLetterValidator() {
        super("capital-letter-exception-list/capital-case-exception-list");
    }

    @Override
    public List<String> getSupportedLanguages() {
        return Collections.singletonList(Locale.ENGLISH.getLanguage());
    }

    @Override
    public void validate(Sentence sentence) {
        String content = sentence.getContent();
        List<TokenElement> tokens = sentence.getTokens();
        String headWord = "";
        for (TokenElement token : tokens) {
            if (token.getSurface().equals("")) continue;
            headWord = token.getSurface();
            break;
        }
        if (tokens.size() == 0 || this.inDictionary(headWord)) {
            return;
        }
        char headChar = '\u2261';
        for (char ch : content.toCharArray()) {
            if (ch == ' ') continue;
            headChar = ch;
            break;
        }
        if (headChar == '\u2261') {
            return;
        }
        if (Character.isLowerCase(headChar)) {
            this.addLocalizedError(sentence, Character.valueOf(headChar));
        }
    }
}

