/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.RedPenException;
import cc.redpen.model.Sentence;
import cc.redpen.util.LevenshteinDistance;
import cc.redpen.validator.Validator;

public class SuccessiveSentenceValidator
extends Validator {
    private Sentence prevSentence = new Sentence("", 1, 0);

    public SuccessiveSentenceValidator() {
        super("dist", 3, "min_len", 5);
    }

    @Override
    protected void init() throws RedPenException {
        super.init();
    }

    @Override
    public void validate(Sentence sentence) {
        if (this.isSame(sentence, this.prevSentence)) {
            this.addLocalizedError(sentence, this.prevSentence.getContent(), sentence.getContent());
        }
        this.prevSentence = sentence;
    }

    private boolean isSame(Sentence sentence, Sentence prevSentence) {
        if (sentence.getContent().length() < this.getInt("min_len")) {
            return false;
        }
        if (sentence.getContent().toLowerCase().equals(prevSentence.getContent().toLowerCase())) {
            return true;
        }
        return LevenshteinDistance.getDistance(sentence.getContent(), prevSentence.getContent()) < this.getInt("dist");
    }
}

