/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.model.Sentence;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.validator.Validator;
import org.parboiled.common.StringUtils;

public class SuccessiveWordValidator
extends Validator {
    @Override
    public void validate(Sentence sentence) {
        String prevSurface = "";
        for (TokenElement token : sentence.getTokens()) {
            String currentSurface = token.getSurface();
            if (prevSurface.equalsIgnoreCase(currentSurface) && currentSurface.length() > 0 && !this.isPartOfNumber(sentence, token)) {
                this.addLocalizedErrorFromToken(sentence, token);
            }
            prevSurface = currentSurface;
        }
    }

    private boolean isPartOfNumber(Sentence sentence, TokenElement token) {
        return StringUtils.substring((String)sentence.getContent(), (int)(token.getOffset() - 1), (int)(token.getOffset() + 2)).matches("\\d.\\d");
    }
}

