/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.RedPenException;
import cc.redpen.model.Sentence;
import cc.redpen.util.StringUtils;
import cc.redpen.validator.Validator;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SuggestExpressionValidator
extends Validator {
    private static final Logger LOG = LoggerFactory.getLogger(SuggestExpressionValidator.class);

    public SuggestExpressionValidator() {
        super("map", new HashMap(), "dict", "");
    }

    @Override
    public void validate(Sentence sentence) {
        String text = sentence.getContent();
        this.getMap("map").keySet().stream().forEach(value -> {
            boolean hasWordBoundaries;
            int start = text.indexOf((String)value);
            if (start < 0) {
                return;
            }
            int end = start + value.length();
            boolean bl = hasWordBoundaries = !(start != 0 && Character.isLetter(text.charAt(start - 1)) || end != text.length() && Character.isLetter(text.charAt(end)));
            if (StringUtils.isProbablyJapanese(text.charAt(start)) || hasWordBoundaries) {
                this.addLocalizedErrorWithPosition(sentence, start, end, value, this.getMap("map").get(value));
            }
        });
    }

    @Override
    protected void init() throws RedPenException {
        String confFile = this.getString("dict");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)confFile)) {
            LOG.info("Dictionary file is " + confFile);
            this.getMap("map").putAll((Map)KEY_VALUE.loadCachedFromFile(this.findFile(confFile), "SuggestExpressionValidator dictionary"));
        } else {
            LOG.warn("Dictionary file is not specified");
        }
    }
}

