/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.config.Symbol;
import cc.redpen.config.SymbolType;
import cc.redpen.model.Sentence;
import cc.redpen.validator.ValidationError;
import cc.redpen.validator.Validator;
import java.util.Set;

public class SymbolWithSpaceValidator
extends Validator {
    @Override
    public void validate(Sentence sentence) {
        Set<SymbolType> symbolTypes = this.getSymbolTable().getNames();
        for (SymbolType symbolType : symbolTypes) {
            this.validateSymbol(sentence, symbolType);
        }
    }

    private ValidationError validateSymbol(Sentence sentence, SymbolType symbolType) {
        String sentenceStr = sentence.getContent();
        Symbol symbol = this.getSymbolTable().getSymbol(symbolType);
        if (!symbol.isNeedAfterSpace() && !symbol.isNeedBeforeSpace()) {
            return null;
        }
        char target = symbol.getValue();
        int position = sentenceStr.indexOf(target);
        if (position != -1) {
            String key = "";
            if (position > 0 && symbol.isNeedBeforeSpace() && !Character.isWhitespace(sentenceStr.charAt(position - 1))) {
                key = "Before";
            }
            if (position < sentenceStr.length() - 1 && symbol.isNeedAfterSpace() && Character.isLetterOrDigit(sentenceStr.charAt(position + 1))) {
                key = key + "After";
            }
            if (!key.isEmpty()) {
                this.addLocalizedErrorWithPosition(key, sentence, position, position + 1, Character.valueOf(sentenceStr.charAt(position)));
            }
        }
        return null;
    }
}

