/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.RedPenException;
import cc.redpen.model.Sentence;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.util.DictionaryLoader;
import cc.redpen.validator.Validator;
import java.util.ArrayList;
import java.util.List;

public class WeakExpressionValidator
extends Validator {
    private static final String DEFAULT_RESOURCE_PATH = "default-resources/weak-expressions";
    private List<String> weakExpressions;

    @Override
    protected void init() throws RedPenException {
        super.init();
        String defaultDictionaryFile = "default-resources/weak-expressions/weak-expressions-" + this.getSymbolTable().getLang() + ".dat";
        this.weakExpressions = new DictionaryLoader<List>(ArrayList::new, (list, line) -> list.add(line.trim().toLowerCase())).loadCachedFromResource(defaultDictionaryFile, "weak expressions");
    }

    @Override
    public void validate(Sentence sentence) {
        TokenElement[] tokens = new TokenElement[]{null, null, null, null, null, null};
        for (int i = 0; i < sentence.getTokens().size(); ++i) {
            for (int j = 0; j < tokens.length - 1; ++j) {
                tokens[j] = i + j < sentence.getTokens().size() ? sentence.getTokens().get(i + j) : null;
            }
            if (tokens[0] == null) continue;
            String expression = "";
            for (int j = 0; j < tokens.length && tokens[j] != null; ++j) {
                if (!this.weakExpressions.contains((expression = expression + (j > 0 ? " " : "") + tokens[j].getSurface()).toLowerCase())) continue;
                this.addLocalizedErrorWithPosition("WeakExpression", sentence, tokens[0].getOffset(), tokens[j].getOffset() + tokens[j].getSurface().length(), expression);
            }
        }
    }
}

