/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.validator.sentence;

import cc.redpen.model.Sentence;
import cc.redpen.tokenizer.TokenElement;
import cc.redpen.validator.Validator;
import java.util.List;

public final class WordNumberValidator
extends Validator {
    public WordNumberValidator() {
        super("max_num", 30);
    }

    @Override
    public void validate(Sentence sentence) {
        List<TokenElement> words = sentence.getTokens();
        int wordNum = 0;
        for (TokenElement word : words) {
            if (word.getSurface().equals(",") || word.getSurface().equals(",") || word.getSurface().equals("?") || word.getSurface().equals("!") || word.getSurface().equals(":") || word.getSurface().equals(";") || word.getSurface().equals("\"") || word.getSurface().equals("'")) continue;
            ++wordNum;
        }
        int maxNum = this.getInt("max_num");
        if (wordNum > maxNum) {
            this.addLocalizedError(sentence, wordNum, maxNum);
        }
    }
}

