/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen;

import cc.redpen.RedPen;
import cc.redpen.RedPenException;
import cc.redpen.formatter.Formatter;
import cc.redpen.model.Document;
import cc.redpen.parser.DocumentParser;
import cc.redpen.util.FormatterUtils;
import cc.redpen.validator.ValidationError;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private static final String PROGRAM = "redpen-cli";
    private static final String DEFAULT_CONFIG_NAME = "redpen-conf";
    private static final int DEFAULT_LIMIT = 1;

    private Main() {
    }

    public static void main(String ... args) throws RedPenException {
        System.exit(Main.run(args));
    }

    public static int run(String ... args) throws RedPenException {
        RedPen redPen;
        File configFile;
        CommandLine commandLine;
        Options options = new Options();
        options.addOption("h", "help", false, "Displays this help information and exits");
        OptionBuilder.withLongOpt((String)"format");
        OptionBuilder.withDescription((String)"Input file format (markdown,plain,wiki,asciidoc,latex,rest)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"FORMAT");
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withLongOpt((String)"conf");
        OptionBuilder.withDescription((String)"Configuration file (REQUIRED)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"CONF FILE");
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"result-format");
        OptionBuilder.withDescription((String)"Output result format (json,json2,plain,plain2,xml)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"RESULT FORMAT");
        options.addOption(OptionBuilder.create((String)"r"));
        OptionBuilder.withLongOpt((String)"limit");
        OptionBuilder.withDescription((String)"Error limit number");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"LIMIT NUMBER");
        options.addOption(OptionBuilder.create((String)"l"));
        OptionBuilder.withLongOpt((String)"sentence");
        OptionBuilder.withDescription((String)"Input sentences");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"INPUT SENTENCES");
        options.addOption(OptionBuilder.create((String)"s"));
        OptionBuilder.withLongOpt((String)"lang");
        OptionBuilder.withDescription((String)"Language of error messages");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"LANGUAGE");
        options.addOption(OptionBuilder.create((String)"L"));
        OptionBuilder.withLongOpt((String)"version");
        OptionBuilder.withDescription((String)"Displays version information and exits");
        options.addOption(OptionBuilder.create((String)"v"));
        BasicParser commandLineParser = new BasicParser();
        try {
            commandLine = commandLineParser.parse(options, args);
        }
        catch (ParseException e) {
            LOG.error("Error occurred in parsing command line options ");
            Main.printHelp(options);
            return -1;
        }
        String inputFormat = "plain";
        String configFileName = null;
        String resultFormat = "plain";
        String inputSentence = null;
        String language = "en";
        int limit = 1;
        if (commandLine.hasOption("h")) {
            Main.printHelp(options);
            return 0;
        }
        if (commandLine.hasOption("v")) {
            System.out.println("1.9.0");
            return 0;
        }
        if (commandLine.hasOption("f")) {
            inputFormat = commandLine.getOptionValue("f");
        }
        if (commandLine.hasOption("c")) {
            configFileName = commandLine.getOptionValue("c");
        }
        if (commandLine.hasOption("r")) {
            resultFormat = commandLine.getOptionValue("r");
        }
        if (commandLine.hasOption("l")) {
            limit = Integer.valueOf(commandLine.getOptionValue("l"));
        }
        if (commandLine.hasOption("L")) {
            language = commandLine.getOptionValue("L");
        }
        if (commandLine.hasOption("s")) {
            inputSentence = commandLine.getOptionValue("s");
        }
        if (language.equals("ja")) {
            Locale.setDefault(new Locale("ja", "JA"));
        } else {
            Locale.setDefault(new Locale("en", "EN"));
        }
        String[] inputFileNames = commandLine.getArgs();
        if (!commandLine.hasOption("f")) {
            inputFormat = Main.guessInputFormat(inputFileNames);
        }
        if ((configFile = Main.resolveConfigLocation(configFileName)) == null) {
            LOG.error("Configuration file is not found.");
            Main.printHelp(options);
            return 1;
        }
        if (inputFileNames.length == 0 && inputSentence == null) {
            LOG.error("Input is not given");
            Main.printHelp(options);
            return 1;
        }
        try {
            redPen = new RedPen(configFile);
        }
        catch (RedPenException e) {
            LOG.error("Failed to parse input files: " + e);
            return -1;
        }
        List<Document> documents = Main.getDocuments(inputFormat, inputSentence, inputFileNames, redPen);
        Map<Document, List<ValidationError>> documentListMap = redPen.validate(documents);
        Formatter formatter = FormatterUtils.getFormatterByName(resultFormat);
        if (formatter == null) {
            LOG.error("Unsupported format: " + resultFormat + " - please use xml, plain, plain2, json or json2");
            return -1;
        }
        String result = formatter.format(documentListMap);
        System.out.println(result);
        long errorCount = documentListMap.values().stream().mapToLong(List::size).sum();
        if (errorCount > (long)limit) {
            LOG.error("The number of errors \"{}\" is larger than specified (limit is \"{}\").", (Object)errorCount, (Object)limit);
            return 1;
        }
        return 0;
    }

    private static List<Document> getDocuments(String inputFormat, String inputSentence, String[] inputFileNames, RedPen redPen) throws RedPenException {
        ArrayList<Document> documents = new ArrayList<Document>();
        DocumentParser parser = DocumentParser.of(inputFormat);
        if (inputSentence == null) {
            documents.addAll(redPen.parse(parser, Main.extractInputFiles(inputFileNames)));
        } else {
            documents.add(redPen.parse(parser, inputSentence));
        }
        return documents;
    }

    static String guessInputFormat(String[] inputFileNames) {
        String inputFormat = "";
        for (String inputFileName : inputFileNames) {
            String format = Main.detectFormat(inputFileName);
            if (!inputFormat.equals("") && !format.equals(inputFormat)) {
                LOG.warn("There are more than one file type...: {} and {}", (Object)format, (Object)inputFormat);
                LOG.warn("Guess file format as plain...");
                return "plain";
            }
            inputFormat = format;
        }
        return inputFormat.equals("") ? "plain" : inputFormat;
    }

    private static String detectFormat(String inputFileName) {
        String ext;
        switch (ext = FilenameUtils.getExtension((String)inputFileName)) {
            case "txt": {
                return "plain";
            }
            case "adoc": 
            case "asciidoc": {
                return "asciidoc";
            }
            case "markdown": 
            case "md": {
                return "markdown";
            }
            case "tex": 
            case "latex": {
                return "latex";
            }
            case "re": 
            case "review": {
                return "review";
            }
            case "properties": {
                return "propery";
            }
            case "rst": 
            case "rest": {
                return "rest";
            }
        }
        LOG.info("No such file extension as \"{}\"", (Object)ext);
        return "plain";
    }

    private static File[] extractInputFiles(String[] inputFileNames) {
        File[] inputFiles = new File[inputFileNames.length];
        for (int i = 0; i < inputFileNames.length; ++i) {
            inputFiles[i] = new File(inputFileNames[i]);
        }
        return inputFiles;
    }

    private static void printHelp(Options opt) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setWidth(100);
        PrintWriter pw = new PrintWriter(System.err);
        formatter.printHelp(pw, 80, "redpen-cli [Options] [<INPUT FILE>]", null, opt, 1, 3, "");
        pw.flush();
    }

    static File resolveConfigLocation(String configFileName) {
        File resolved;
        ArrayList<String> pathCandidates = new ArrayList<String>();
        if (configFileName != null) {
            pathCandidates.add(configFileName);
        }
        pathCandidates.add("redpen-conf.xml");
        pathCandidates.add("redpen-conf-" + Locale.getDefault().getLanguage() + ".xml");
        String redpenHome = System.getenv("REDPEN_HOME");
        if (redpenHome != null) {
            pathCandidates.add(redpenHome + File.separator + DEFAULT_CONFIG_NAME + ".xml");
            pathCandidates.add(redpenHome + File.separator + DEFAULT_CONFIG_NAME + "-" + Locale.getDefault().getLanguage() + ".xml");
            pathCandidates.add(redpenHome + File.separator + "conf" + File.separator + DEFAULT_CONFIG_NAME + ".xml");
            pathCandidates.add(redpenHome + File.separator + "conf" + File.separator + DEFAULT_CONFIG_NAME + "-" + Locale.getDefault().getLanguage() + ".xml");
        }
        if ((resolved = Main.resolve(pathCandidates)) != null && resolved.exists() && resolved.isFile()) {
            LOG.info("Configuration file: {}", (Object)resolved.getAbsolutePath());
        } else {
            resolved = null;
        }
        return resolved;
    }

    static File resolve(List<String> pathCandidates) {
        for (String pathCandidate : pathCandidates) {
            File resolved = new File(pathCandidate);
            if (!resolved.exists() || !resolved.isFile()) continue;
            return resolved;
        }
        return null;
    }
}

