/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.buffer;

import com.atilika.kuromoji.io.ByteBufferIO;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.TreeMap;

public class StringValueMapBuffer {
    private static final int INTEGER_BYTES = 4;
    private static final int SHORT_BYTES = 2;
    private ByteBuffer buffer;

    public StringValueMapBuffer(TreeMap<Integer, String> features) {
        this.putMap(features);
    }

    public StringValueMapBuffer(InputStream is) throws IOException {
        this.buffer = ByteBufferIO.read(is);
    }

    private static int getMetaDataSize() {
        return 4;
    }

    public void putMap(TreeMap<Integer, String> input) {
        this.buffer = ByteBuffer.wrap(new byte[this.calculateSize(input) + StringValueMapBuffer.getMetaDataSize()]);
        this.buffer.putInt(input.size());
        int position = StringValueMapBuffer.getMetaDataSize();
        int address = position + input.size() * 4;
        for (Integer index : input.keySet()) {
            this.buffer.putInt(position, address);
            address = this.putString(address, input.get(index));
            position += 4;
        }
    }

    private int calculateSize(TreeMap<Integer, String> input) {
        int size = 0;
        for (String value : input.values()) {
            size += 4 + value.getBytes(StandardCharsets.UTF_8).length + 8;
        }
        return size;
    }

    private int putString(int address, String s) {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        this.buffer.position(address);
        this.buffer.putShort((short)bytes.length);
        this.buffer.put(bytes);
        return address + 2 + bytes.length;
    }

    public String get(int i) {
        int address = this.buffer.getInt(i * 4 + StringValueMapBuffer.getMetaDataSize());
        return this.getString(address);
    }

    private String getString(int address) {
        short length = this.buffer.getShort(address);
        return new String(this.buffer.array(), address + 2, (int)length, StandardCharsets.UTF_8);
    }

    public void write(OutputStream os) throws IOException {
        ByteBufferIO.write(os, this.buffer);
    }
}

