/*
 * Decompiled with CFR 0.152.
 */
package cc.renken.pipeio.impl;

import cc.renken.pipeio.IAsyncComponentContainer;
import cc.renken.pipeio.IAsyncFaucet;
import cc.renken.pipeio.IComponent;
import cc.renken.pipeio.IScheduler;
import cc.renken.pipeio.ISyncPushFaucet;
import cc.renken.pipeio.ISyncPushFaucetContainer;
import cc.renken.pipeio.ISyncReceiveFaucet;
import cc.renken.pipeio.State;
import cc.renken.pipeio.config.Configuration;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

final class SyncFaucetContainerAdapter<RECV, PUSH>
implements ISyncPushFaucetContainer<RECV, PUSH>,
IAsyncFaucet<RECV, PUSH> {
    private IAsyncComponentContainer<Void, PUSH> handler;
    private final IComponent<RECV, PUSH> genericFaucet;
    private ISyncPushFaucet<RECV, PUSH> pushFaucet;
    private ISyncReceiveFaucet<RECV, PUSH> recvFaucet;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition entityReceived = this.lock.newCondition();
    private boolean awaiting = false;
    private RECV receivedEntity;

    public SyncFaucetContainerAdapter(ISyncPushFaucet<RECV, PUSH> faucet) {
        this.pushFaucet = faucet;
        this.genericFaucet = faucet;
    }

    public SyncFaucetContainerAdapter(ISyncReceiveFaucet<RECV, PUSH> faucet) {
        this.recvFaucet = faucet;
        this.genericFaucet = faucet;
    }

    public void setup(IAsyncComponentContainer<Void, PUSH> handler) {
        this.handler = handler;
        if (this.pushFaucet != null) {
            this.pushFaucet.setup(this);
            return;
        }
        this.recvFaucet.setup(this);
    }

    public void activateNext() throws IOException, TimeoutException {
        this.handler.activateNext();
    }

    public void notifyActiveStateChanged() {
        this.handler.notifyActiveStateChanged();
    }

    public State getNextState() {
        return this.handler.getNextState();
    }

    public void deactivateNext() {
        this.handler.deactivateNext();
    }

    public IScheduler getScheduler() {
        return this.handler.getScheduler();
    }

    public void exceptionEncountered(Exception ex) {
        this.handler.exceptionEncountered(ex);
    }

    public void activate(Configuration config) throws IOException, TimeoutException {
        this.genericFaucet.activate(config);
    }

    public void activeStateChanged() {
        this.genericFaucet.activeStateChanged();
    }

    public State getState() {
        return this.genericFaucet.getState();
    }

    public void deactivate() {
        this.genericFaucet.deactivate();
    }

    public void receive(RECV entity) {
        this.lock.lock();
        try {
            if (this.pushFaucet != null) {
                this.handleReceivePushFaucet(entity);
                return;
            }
            this.handleReceiveRecvFaucet(entity);
        }
        finally {
            this.lock.unlock();
        }
    }

    private final void handleReceiveRecvFaucet(RECV entity) {
        PUSH push = this.recvFaucet.receive(entity);
        try {
            this.handler.pushToNext(push);
        }
        catch (IOException | TimeoutException e) {
            this.exceptionEncountered(e);
        }
    }

    private final void handleReceivePushFaucet(RECV entity) {
        if (!this.awaiting) {
            this.exceptionEncountered(new IllegalStateException("Received data " + entity + " while no one was expecting it."));
            return;
        }
        this.receivedEntity = entity;
        this.entityReceived.signal();
    }

    @Override
    public RECV pushToNext(PUSH entity) throws IOException, TimeoutException {
        this.lock.lock();
        try {
            this.awaiting = true;
            this.handler.pushToNext(entity);
            if (!this.entityReceived.await(10000L, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException("Didn't get response for " + entity + " within time limit.");
            }
            RECV RECV = this.receivedEntity;
            return RECV;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            this.awaiting = false;
            this.lock.unlock();
        }
    }
}

