/*
 * Decompiled with CFR 0.152.
 */
package cc.renken.pipeio.impl;

import cc.renken.pipeio.IAsyncSink;
import cc.renken.pipeio.IAsyncTube;
import cc.renken.pipeio.IPipeline;
import cc.renken.pipeio.ISyncPushFaucet;
import cc.renken.pipeio.ISyncReceiveFaucet;
import cc.renken.pipeio.impl.SyncPipeline;
import java.util.LinkedHashSet;

public final class SyncFlow<RECV, PUSH> {
    private final LinkedHashSet<IAsyncTube<?, ?, ?, ?>> parts = new LinkedHashSet();
    private final ISyncPushFaucet<RECV, PUSH> pushFaucet;
    private final ISyncReceiveFaucet<RECV, PUSH> recvFaucet;
    private IAsyncSink<?, ?> asyncSink;

    private SyncFlow(ISyncPushFaucet<RECV, PUSH> faucet) {
        this.pushFaucet = faucet;
        this.recvFaucet = null;
    }

    private SyncFlow(ISyncReceiveFaucet<RECV, PUSH> faucet) {
        this.recvFaucet = faucet;
        this.pushFaucet = null;
    }

    public static final <RECV, PUSH> Flowing<RECV, PUSH, RECV, PUSH> from(ISyncPushFaucet<RECV, PUSH> faucet) {
        SyncFlow<RECV, PUSH> flow = new SyncFlow<RECV, PUSH>(faucet);
        return new Flowing(flow);
    }

    public static final <RECV, PUSH> Flowing<RECV, PUSH, RECV, PUSH> from(ISyncReceiveFaucet<RECV, PUSH> faucet) {
        SyncFlow<RECV, PUSH> flow = new SyncFlow<RECV, PUSH>(faucet);
        return new Flowing(flow);
    }

    public static final class Finishing<RECV, PUSH> {
        private final SyncFlow<RECV, PUSH> syncFlow;

        private Finishing(SyncFlow<RECV, PUSH> flow) {
            this.syncFlow = flow;
        }

        public final IPipeline<RECV, PUSH> byId(String id) {
            SyncPipeline pipe = ((SyncFlow)this.syncFlow).pushFaucet != null ? new SyncPipeline(id, ((SyncFlow)this.syncFlow).pushFaucet, ((SyncFlow)this.syncFlow).parts, ((SyncFlow)this.syncFlow).asyncSink) : new SyncPipeline(id, ((SyncFlow)this.syncFlow).recvFaucet, ((SyncFlow)this.syncFlow).parts, ((SyncFlow)this.syncFlow).asyncSink);
            return pipe;
        }

        public final IPipeline<RECV, PUSH> compile() {
            SyncPipeline pipe = ((SyncFlow)this.syncFlow).pushFaucet != null ? new SyncPipeline(((SyncFlow)this.syncFlow).pushFaucet, ((SyncFlow)this.syncFlow).parts, ((SyncFlow)this.syncFlow).asyncSink) : new SyncPipeline(((SyncFlow)this.syncFlow).recvFaucet, ((SyncFlow)this.syncFlow).parts, ((SyncFlow)this.syncFlow).asyncSink);
            return pipe;
        }
    }

    public static final class Flowing<RECV_OUT, PUSH_IN, RECV, PUSH> {
        private final SyncFlow<RECV, PUSH> syncFlow;

        private Flowing(SyncFlow<RECV, PUSH> flow) {
            this.syncFlow = flow;
        }

        public final <RECV_IN, PUSH_OUT> Flowing<RECV_IN, PUSH_OUT, RECV, PUSH> through(IAsyncTube<RECV_IN, RECV_OUT, PUSH_IN, PUSH_OUT> part) {
            ((SyncFlow)this.syncFlow).parts.add(part);
            return new Flowing<RECV_OUT, PUSH_IN, RECV, PUSH>(this.syncFlow);
        }

        public final Finishing<RECV, PUSH> into(IAsyncSink<RECV_OUT, PUSH_IN> sink) {
            ((SyncFlow)this.syncFlow).asyncSink = sink;
            return new Finishing(this.syncFlow);
        }
    }
}

