/*
 * Decompiled with CFR 0.152.
 */
package cc.renken.pipeio.impl;

import cc.renken.pipeio.IAsyncSink;
import cc.renken.pipeio.IAsyncTube;
import cc.renken.pipeio.IPipeline;
import cc.renken.pipeio.ISyncPushFaucet;
import cc.renken.pipeio.ISyncReceiveFaucet;
import cc.renken.pipeio.State;
import cc.renken.pipeio.config.Configuration;
import cc.renken.pipeio.config.PropertyModel;
import cc.renken.pipeio.config.PropertyModelBuilder;
import cc.renken.pipeio.impl.AAsyncComponentContainer;
import cc.renken.pipeio.impl.APipeline;
import cc.renken.pipeio.impl.AsyncFaucetContainer;
import cc.renken.pipeio.impl.AsyncSinkContainer;
import cc.renken.pipeio.impl.AsyncTubeContainer;
import cc.renken.pipeio.impl.Scheduler;
import cc.renken.pipeio.impl.SyncFaucetContainerAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

class SyncPipeline<RECV, PUSH>
extends APipeline<RECV, PUSH>
implements IPipeline<RECV, PUSH> {
    private final AsyncFaucetContainer<RECV, PUSH> asyncFaucetContainer;
    private final LinkedList<AsyncTubeContainer<?, ?, ?, ?>> partHandlers = new LinkedList();
    private final AsyncSinkContainer<?, ?> asyncSinkContainer;
    private final PropertyModel propertyModel;

    public SyncPipeline(ISyncPushFaucet<RECV, PUSH> faucet, LinkedHashSet<IAsyncTube<?, ?, ?, ?>> parts, IAsyncSink<?, ?> sink) {
        this(null, faucet, parts, sink);
    }

    public SyncPipeline(ISyncReceiveFaucet<RECV, PUSH> faucet, LinkedHashSet<IAsyncTube<?, ?, ?, ?>> parts, IAsyncSink<?, ?> sink) {
        this(null, faucet, parts, sink);
    }

    public SyncPipeline(String id, ISyncPushFaucet<RECV, PUSH> faucet, LinkedHashSet<IAsyncTube<?, ?, ?, ?>> parts, IAsyncSink<?, ?> sink) {
        this(id, faucet, true, parts, sink);
    }

    public SyncPipeline(String id, ISyncReceiveFaucet<RECV, PUSH> faucet, LinkedHashSet<IAsyncTube<?, ?, ?, ?>> parts, IAsyncSink<?, ?> sink) {
        this(id, faucet, false, parts, sink);
    }

    private SyncPipeline(String id, Object faucet, boolean push, LinkedHashSet<IAsyncTube<?, ?, ?, ?>> parts, IAsyncSink<?, ?> sink) {
        super(id);
        this.asyncSinkContainer = new AsyncSinkContainer(this.scheduler(), sink, this::exceptionEncounteredNotifyListeners);
        AsyncTubeContainer next = this.asyncSinkContainer;
        ArrayList partsRevs = new ArrayList(parts);
        Collections.reverse(partsRevs);
        for (IAsyncTube iAsyncTube : partsRevs) {
            AsyncTubeContainer handler = new AsyncTubeContainer(this.scheduler(), iAsyncTube, next, this::exceptionEncounteredNotifyListeners);
            this.partHandlers.addFirst(handler);
            next = handler;
        }
        AAsyncComponentContainer firstHandler = !this.partHandlers.isEmpty() ? (AAsyncComponentContainer)this.partHandlers.getFirst() : this.asyncSinkContainer;
        SyncFaucetContainerAdapter syncFaucetContainerAdapter = push ? new SyncFaucetContainerAdapter((ISyncPushFaucet)faucet) : new SyncFaucetContainerAdapter((ISyncReceiveFaucet)faucet);
        this.asyncFaucetContainer = new AsyncFaucetContainer((APipeline)this, syncFaucetContainerAdapter, firstHandler, this::exceptionEncounteredNotifyListeners);
        PropertyModelBuilder pmBuilder = PropertyModelBuilder.create();
        pmBuilder.addPropertiesFromType(faucet.getClass());
        for (IAsyncTube iAsyncTube : partsRevs) {
            pmBuilder.addPropertiesFromType(iAsyncTube.getClass());
        }
        pmBuilder.addPropertiesFromType(sink.getClass());
        this.propertyModel = pmBuilder.compile();
    }

    protected void activateFaucet(Configuration config) throws IOException, TimeoutException {
        this.asyncFaucetContainer.activateFaucet(config);
    }

    protected State getFaucetState() {
        return this.asyncFaucetContainer.getFaucetState();
    }

    protected void deactivateFaucet() {
        this.asyncFaucetContainer.deactivateFaucet();
    }

    protected Scheduler scheduler() {
        return super.scheduler();
    }

    protected final void stateChangedNotifyListeners() throws ExecutionException, TimeoutException {
        super.stateChangedNotifyListeners();
    }

    protected final void receivedNotifyListeners(RECV entity) {
        super.receivedNotifyListeners(entity);
    }

    protected final void sendNotifyListeners(PUSH entity) {
        super.sendNotifyListeners(entity);
    }

    protected final void exceptionEncounteredNotifyListeners(Exception ex) {
        super.exceptionEncounteredNotifyListeners(ex);
    }

    public PropertyModel getConfigurationModel() {
        return this.propertyModel;
    }
}

