/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.nlp.embedding;

import cc.unitmesh.nlp.embedding.EncodingTokenizer;
import com.knuddels.jtokkit.Encodings;
import com.knuddels.jtokkit.api.Encoding;
import com.knuddels.jtokkit.api.EncodingRegistry;
import com.knuddels.jtokkit.api.EncodingType;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\r\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcc/unitmesh/nlp/embedding/OpenAiEncoding;", "Lcc/unitmesh/nlp/embedding/EncodingTokenizer;", "()V", "encoding", "Lcom/knuddels/jtokkit/api/Encoding;", "registry", "Lcom/knuddels/jtokkit/api/EncodingRegistry;", "decode", "", "tokens", "", "", "encode", "text", "cocoa-core"})
public final class OpenAiEncoding
implements EncodingTokenizer {
    @NotNull
    private final EncodingRegistry registry;
    @NotNull
    private final Encoding encoding;

    public OpenAiEncoding() {
        EncodingRegistry encodingRegistry = Encodings.newLazyEncodingRegistry();
        Intrinsics.checkNotNullExpressionValue(encodingRegistry, "newLazyEncodingRegistry(...)");
        this.registry = encodingRegistry;
        Encoding encoding = this.registry.getEncoding(EncodingType.CL100K_BASE);
        Intrinsics.checkNotNullExpressionValue(encoding, "getEncoding(...)");
        this.encoding = encoding;
    }

    @Override
    @NotNull
    public List<Integer> encode(@NotNull String text) {
        Intrinsics.checkNotNullParameter(text, "text");
        List<Integer> list = this.encoding.encode(text);
        Intrinsics.checkNotNullExpressionValue(list, "encode(...)");
        return list;
    }

    @Override
    @NotNull
    public String decode(@NotNull List<Integer> tokens) {
        Intrinsics.checkNotNullParameter(tokens, "tokens");
        String string = this.encoding.decode(tokens);
        Intrinsics.checkNotNullExpressionValue(string, "decode(...)");
        return string;
    }
}

