/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.nlp.similarity;

import cc.unitmesh.nlp.similarity.Similarity;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0010\u0010\u0005\u001a\f\u0012\u0004\u0012\u00020\u00040\u0006j\u0002`\u00072\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\u00040\u0006j\u0002`\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcc/unitmesh/nlp/similarity/CosineSimilarity;", "Lcc/unitmesh/nlp/similarity/Similarity;", "()V", "similarityScore", "", "vectorA", "", "Lcc/unitmesh/nlp/embedding/Embedding;", "vectorB", "Companion", "cocoa-core"})
public final class CosineSimilarity
implements Similarity {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public double similarityScore(@NotNull List<Double> vectorA, @NotNull List<Double> vectorB) {
        Intrinsics.checkNotNullParameter(vectorA, "vectorA");
        Intrinsics.checkNotNullParameter(vectorB, "vectorB");
        if (vectorA.size() != vectorB.size()) {
            throw new IllegalArgumentException("Length of vector a (" + vectorA.size() + ") must be equal to the length of vector b (" + vectorB.size() + ")");
        }
        double dotProduct = 0.0;
        double normA = 0.0;
        double normB = 0.0;
        int n = vectorA.size();
        for (int i = 0; i < n; ++i) {
            dotProduct += ((Number)vectorA.get(i)).doubleValue() * ((Number)vectorB.get(i)).doubleValue();
            normA += ((Number)vectorA.get(i)).doubleValue() * ((Number)vectorA.get(i)).doubleValue();
            normB += ((Number)vectorB.get(i)).doubleValue() * ((Number)vectorB.get(i)).doubleValue();
        }
        return dotProduct / (Math.sqrt(normA) * Math.sqrt(normB));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a8\u0006\b"}, d2={"Lcc/unitmesh/nlp/similarity/CosineSimilarity$Companion;", "", "()V", "between", "", "embedding", "", "referenceEmbedding", "cocoa-core"})
    public static final class Companion {
        private Companion() {
        }

        public final double between(@NotNull List<Double> embedding, @NotNull List<Double> referenceEmbedding) {
            Intrinsics.checkNotNullParameter(embedding, "embedding");
            Intrinsics.checkNotNullParameter(referenceEmbedding, "referenceEmbedding");
            return new CosineSimilarity().similarityScore(embedding, referenceEmbedding);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

