/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.openai;

import cc.unitmesh.nlp.embedding.EmbeddingProvider;
import cc.unitmesh.rag.document.Document;
import com.theokanning.openai.embedding.Embedding;
import com.theokanning.openai.embedding.EmbeddingRequest;
import com.theokanning.openai.embedding.EmbeddingResult;
import com.theokanning.openai.service.OpenAiService;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0017\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00190\u0018j\u0002`\u001a0\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\b"}, d2={"Lcc/unitmesh/openai/OpenAiEmbeddingProvider;", "Lcc/unitmesh/nlp/embedding/EmbeddingProvider;", "apiKey", "", "(Ljava/lang/String;)V", "getApiKey", "()Ljava/lang/String;", "setApiKey", "openai", "Lcom/theokanning/openai/service/OpenAiService;", "getOpenai", "()Lcom/theokanning/openai/service/OpenAiService;", "openai$delegate", "Lkotlin/Lazy;", "timeout", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "totalTokens", "", "getTotalTokens", "()J", "setTotalTokens", "(J)V", "embed", "", "", "Lcc/unitmesh/nlp/embedding/Embedding;", "texts"})
@SourceDebugExtension(value={"SMAP\nOpenAiEmbeddingProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAiEmbeddingProvider.kt\ncc/unitmesh/openai/OpenAiEmbeddingProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,21:1\n1549#2:22\n1620#2,3:23\n*S KotlinDebug\n*F\n+ 1 OpenAiEmbeddingProvider.kt\ncc/unitmesh/openai/OpenAiEmbeddingProvider\n*L\n19#1:22\n19#1:23,3\n*E\n"})
public final class OpenAiEmbeddingProvider
implements EmbeddingProvider {
    @NotNull
    private String apiKey;
    private final Duration timeout;
    private long totalTokens;
    @NotNull
    private final Lazy openai$delegate;

    public OpenAiEmbeddingProvider(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter(apiKey, "apiKey");
        this.apiKey = apiKey;
        this.timeout = Duration.ofSeconds(600L);
        this.openai$delegate = LazyKt.lazy((Function0)new Function0<OpenAiService>(this){
            final /* synthetic */ OpenAiEmbeddingProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final OpenAiService invoke() {
                return new OpenAiService(this.this$0.getApiKey(), OpenAiEmbeddingProvider.access$getTimeout$p(this.this$0));
            }
        });
    }

    @NotNull
    public final String getApiKey() {
        return this.apiKey;
    }

    public final void setApiKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.apiKey = string;
    }

    public final long getTotalTokens() {
        return this.totalTokens;
    }

    public final void setTotalTokens(long l) {
        this.totalTokens = l;
    }

    private final OpenAiService getOpenai() {
        Lazy lazy = this.openai$delegate;
        return (OpenAiService)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<List<Double>> embed(@NotNull List<String> texts) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(texts, "texts");
        EmbeddingRequest request = EmbeddingRequest.builder().model("text-embedding-ada-002").input(texts).build();
        EmbeddingResult response = this.getOpenai().createEmbeddings(request);
        this.totalTokens += response.getUsage().getTotalTokens();
        List<Embedding> list = response.getData();
        Intrinsics.checkNotNullExpressionValue(list, "getData(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Embedding embedding = (Embedding)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEmbedding());
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<Double> embed(@NotNull Document document) {
        return EmbeddingProvider.DefaultImpls.embed((EmbeddingProvider)this, document);
    }

    @Override
    @NotNull
    public List<Double> embed(@NotNull String text) {
        return EmbeddingProvider.DefaultImpls.embed((EmbeddingProvider)this, text);
    }

    public static final /* synthetic */ Duration access$getTimeout$p(OpenAiEmbeddingProvider $this) {
        return $this.timeout;
    }
}

