/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.openai;

import cc.unitmesh.cf.core.llms.LlmMsg;
import cc.unitmesh.cf.core.llms.LlmProvider;
import cc.unitmesh.cf.core.llms.TemperatureMode;
import cc.unitmesh.openai.OpenAiProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.theokanning.openai.client.OpenAiApi;
import com.theokanning.openai.completion.chat.ChatCompletionChoice;
import com.theokanning.openai.completion.chat.ChatCompletionChunk;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.service.OpenAiService;
import io.reactivex.disposables.Disposable;
import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableEmitter;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0018\u001a\u00020\u00032\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\n\u0010 \u001a\u00020!*\u00020\u001bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\tR\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0012\u001a\u00020\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\f"}, d2={"Lcc/unitmesh/openai/OpenAiProvider;", "Lcc/unitmesh/cf/core/llms/LlmProvider;", "apiKey", "", "apiHost", "(Ljava/lang/String;Ljava/lang/String;)V", "getApiHost", "()Ljava/lang/String;", "setApiHost", "(Ljava/lang/String;)V", "getApiKey", "setApiKey", "openai", "Lcom/theokanning/openai/service/OpenAiService;", "getOpenai", "()Lcom/theokanning/openai/service/OpenAiService;", "openai$delegate", "Lkotlin/Lazy;", "temperature", "", "getTemperature", "()D", "setTemperature", "(D)V", "completion", "messages", "", "Lcc/unitmesh/cf/core/llms/LlmMsg$ChatMessage;", "prepareRequest", "Lcom/theokanning/openai/completion/chat/ChatCompletionRequest;", "streamCompletion", "Lio/reactivex/rxjava3/core/Flowable;", "toInternal", "Lcom/theokanning/openai/completion/chat/ChatMessage;"})
@SourceDebugExtension(value={"SMAP\nOpenAiProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAiProvider.kt\ncc/unitmesh/openai/OpenAiProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1549#2:99\n1620#2,3:100\n*S KotlinDebug\n*F\n+ 1 OpenAiProvider.kt\ncc/unitmesh/openai/OpenAiProvider\n*L\n45#1:99\n45#1:100,3\n*E\n"})
public final class OpenAiProvider
implements LlmProvider {
    @NotNull
    private String apiKey;
    @Nullable
    private String apiHost;
    private double temperature;
    @NotNull
    private final Lazy openai$delegate;

    public OpenAiProvider(@NotNull String apiKey, @Nullable String apiHost) {
        Intrinsics.checkNotNullParameter(apiKey, "apiKey");
        this.apiKey = apiKey;
        this.apiHost = apiHost;
        this.openai$delegate = LazyKt.lazy((Function0)new Function0<OpenAiService>(this){
            final /* synthetic */ OpenAiProvider this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final OpenAiService invoke() {
                OpenAiService openAiService;
                if (this.this$0.getApiHost() != null) {
                    ObjectMapper mapper = OpenAiService.defaultObjectMapper();
                    OkHttpClient client = OpenAiService.defaultClient(this.this$0.getApiKey(), Duration.ZERO);
                    String string = this.this$0.getApiHost();
                    Intrinsics.checkNotNull(string);
                    String host = StringsKt.removeSurrounding(string, (CharSequence)"\"");
                    Retrofit retrofit = new Retrofit.Builder().baseUrl(host).client(client).addConverterFactory(JacksonConverterFactory.create(mapper)).addCallAdapterFactory(RxJava2CallAdapterFactory.create()).build();
                    Intrinsics.checkNotNullExpressionValue(retrofit, "build(...)");
                    Retrofit retrofit2 = retrofit;
                    OpenAiApi openAiApi = retrofit2.create(OpenAiApi.class);
                    Intrinsics.checkNotNullExpressionValue(openAiApi, "create(...)");
                    OpenAiApi api = openAiApi;
                    openAiService = new OpenAiService(api);
                } else {
                    openAiService = new OpenAiService(this.this$0.getApiKey(), Duration.ZERO);
                }
                return openAiService;
            }
        });
    }

    public /* synthetic */ OpenAiProvider(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @NotNull
    public final String getApiKey() {
        return this.apiKey;
    }

    public final void setApiKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.apiKey = string;
    }

    @Nullable
    public final String getApiHost() {
        return this.apiHost;
    }

    public final void setApiHost(@Nullable String string) {
        this.apiHost = string;
    }

    @Override
    public double getTemperature() {
        return this.temperature;
    }

    @Override
    public void setTemperature(double d) {
        this.temperature = d;
    }

    private final OpenAiService getOpenai() {
        Lazy lazy = this.openai$delegate;
        return (OpenAiService)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final ChatCompletionRequest prepareRequest(List<LlmMsg.ChatMessage> messages) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = messages;
        ChatCompletionRequest.ChatCompletionRequestBuilder chatCompletionRequestBuilder = ChatCompletionRequest.builder().model("gpt-3.5-turbo").temperature(this.getTemperature());
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LlmMsg.ChatMessage chatMessage = (LlmMsg.ChatMessage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.toInternal((LlmMsg.ChatMessage)it));
        }
        return chatCompletionRequestBuilder.messages((List)destination$iv$iv).stream(false).build();
    }

    @NotNull
    public final ChatMessage toInternal(@NotNull LlmMsg.ChatMessage $this$toInternal) {
        Intrinsics.checkNotNullParameter($this$toInternal, "<this>");
        String string = $this$toInternal.getRole().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        return new ChatMessage(string, $this$toInternal.getContent());
    }

    @Override
    @NotNull
    public String completion(@NotNull List<LlmMsg.ChatMessage> messages) {
        Intrinsics.checkNotNullParameter(messages, "messages");
        ChatCompletionRequest request = this.prepareRequest(messages);
        Ref.ObjectRef<String> result2 = new Ref.ObjectRef<String>();
        result2.element = "";
        this.getOpenai().streamChatCompletion(request).blockingForEach(arg_0 -> OpenAiProvider.completion$lambda$1(new Function1<ChatCompletionChunk, Unit>(result2){
            final /* synthetic */ Ref.ObjectRef<String> $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(ChatCompletionChunk response) {
                ChatMessage completion2;
                List<ChatCompletionChoice> list = response.getChoices();
                ChatMessage chatMessage = list != null && (list = list.get(0)) != null ? ((ChatCompletionChoice)((Object)list)).getMessage() : (completion2 = null);
                if (completion2 != null && completion2.getContent() != null) {
                    this.$result.element = this.$result.element + completion2.getContent();
                }
            }
        }, arg_0));
        return (String)result2.element;
    }

    @Override
    @NotNull
    public Flowable<String> streamCompletion(@NotNull List<LlmMsg.ChatMessage> messages) {
        Intrinsics.checkNotNullParameter(messages, "messages");
        ChatCompletionRequest request = this.prepareRequest(messages);
        Flowable<String> flowable = Flowable.create(arg_0 -> OpenAiProvider.streamCompletion$lambda$7(this, request, arg_0), BackpressureStrategy.BUFFER).subscribeOn(Schedulers.io()).observeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue(flowable, "observeOn(...)");
        return flowable;
    }

    @Override
    public void setTemperatureMode(@NotNull TemperatureMode mode) {
        LlmProvider.DefaultImpls.setTemperatureMode(this, mode);
    }

    private static final void completion$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void streamCompletion$lambda$7$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void streamCompletion$lambda$7$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void streamCompletion$lambda$7$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void streamCompletion$lambda$7$lambda$5(FlowableEmitter $emitter) {
        Intrinsics.checkNotNullParameter($emitter, "$emitter");
        $emitter.onComplete();
    }

    private static final void streamCompletion$lambda$7$lambda$6(Disposable $disposable) {
        $disposable.dispose();
    }

    private static final void streamCompletion$lambda$7(OpenAiProvider this$0, ChatCompletionRequest $request, FlowableEmitter emitter) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(emitter, "emitter");
        Disposable disposable2 = this$0.getOpenai().streamChatCompletion($request).doOnSubscribe(arg_0 -> OpenAiProvider.streamCompletion$lambda$7$lambda$2(streamCompletion.1.disposable.1.INSTANCE, arg_0)).subscribe(arg_0 -> OpenAiProvider.streamCompletion$lambda$7$lambda$3(new Function1<ChatCompletionChunk, Unit>((FlowableEmitter<String>)emitter){
            final /* synthetic */ FlowableEmitter<String> $emitter;
            {
                this.$emitter = $emitter;
                super(1);
            }

            public final void invoke(ChatCompletionChunk response) {
                ChatMessage completion2 = response.getChoices().get(0).getMessage();
                if (completion2 != null && completion2.getContent() != null) {
                    this.$emitter.onNext(completion2.getContent());
                }
            }
        }, arg_0), arg_0 -> OpenAiProvider.streamCompletion$lambda$7$lambda$4(new Function1<Throwable, Unit>((FlowableEmitter<String>)emitter){
            final /* synthetic */ FlowableEmitter<String> $emitter;
            {
                this.$emitter = $emitter;
                super(1);
            }

            public final void invoke(Throwable error) {
                this.$emitter.onError(error);
            }
        }, arg_0), () -> OpenAiProvider.streamCompletion$lambda$7$lambda$5(emitter));
        emitter.setCancellable(() -> OpenAiProvider.streamCompletion$lambda$7$lambda$6(disposable2));
    }
}

