/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.prompt.executor;

import cc.unitmesh.prompt.executor.strategy.ConnectionExecuteStrategy;
import cc.unitmesh.prompt.executor.strategy.DatasourceCollectionStrategy;
import cc.unitmesh.prompt.executor.strategy.RepeatExecuteStrategy;
import cc.unitmesh.prompt.model.Job;
import cc.unitmesh.prompt.model.JobStrategy;
import cc.unitmesh.prompt.model.PromptScript;
import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0012\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u000bR\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcc/unitmesh/prompt/executor/ScriptExecutor;", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "content", "", "(Ljava/lang/String;)V", "basePath", "Ljava/nio/file/Path;", "execStrategy", "", "strategy", "Lcc/unitmesh/prompt/model/JobStrategy;", "jobName", "job", "Lcc/unitmesh/prompt/model/Job;", "execute", "Companion", "prompt-script"})
@SourceDebugExtension(value={"SMAP\nScriptExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptExecutor.kt\ncc/unitmesh/prompt/executor/ScriptExecutor\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,54:1\n215#2:55\n216#2:58\n1855#3,2:56\n*S KotlinDebug\n*F\n+ 1 ScriptExecutor.kt\ncc/unitmesh/prompt/executor/ScriptExecutor\n*L\n33#1:55\n33#1:58\n34#1:56,2\n*E\n"})
public final class ScriptExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String content;
    private Path basePath;
    @NotNull
    private static final Logger log;

    public ScriptExecutor(@NotNull File file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        this(FilesKt.readText(file2, Charsets.UTF_8));
        Path path2 = file2.toPath().getParent();
        Intrinsics.checkNotNullExpressionValue(path2, "getParent(...)");
        this.basePath = path2;
    }

    private ScriptExecutor(String content) {
        this.content = content;
    }

    public final void execute() {
        PromptScript promptScript = PromptScript.Companion.fromString(this.content);
        if (promptScript == null) {
            return;
        }
        PromptScript script = promptScript;
        Map<String, Job> $this$forEach$iv = script.getJobs();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, Job>> iterator2 = $this$forEach$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, Job> element$iv;
            Map.Entry<String, Job> entry = element$iv = iterator2.next();
            boolean bl = false;
            String name = entry.getKey();
            Job job = entry.getValue();
            Iterable $this$forEach$iv2 = job.getStrategy();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                JobStrategy it = (JobStrategy)element$iv2;
                boolean bl2 = false;
                this.execStrategy(it, name, job);
            }
        }
    }

    private final void execStrategy(JobStrategy strategy, String jobName, Job job) {
        JobStrategy jobStrategy = strategy;
        if (jobStrategy instanceof JobStrategy.Connection) {
            Path path2 = this.basePath;
            if (path2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("basePath");
                path2 = null;
            }
            new ConnectionExecuteStrategy(jobName, job, path2, (JobStrategy.Connection)strategy).execute();
        } else if (jobStrategy instanceof JobStrategy.Repeat) {
            Path path3 = this.basePath;
            if (path3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("basePath");
                path3 = null;
            }
            new RepeatExecuteStrategy(jobName, job, path3, (JobStrategy.Repeat)strategy).execute();
        } else if (jobStrategy instanceof JobStrategy.DatasourceCollection) {
            Path path4 = this.basePath;
            if (path4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("basePath");
                path4 = null;
            }
            new DatasourceCollectionStrategy(job, path4, jobName, (JobStrategy.DatasourceCollection)strategy).execute();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(ScriptExecutor.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcc/unitmesh/prompt/executor/ScriptExecutor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "prompt-script"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

