/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.prompt.executor.base;

import cc.unitmesh.cf.core.llms.LlmProvider;
import cc.unitmesh.cf.core.llms.MockLlmProvider;
import cc.unitmesh.connection.ConnectionConfig;
import cc.unitmesh.connection.MockLlmConnection;
import cc.unitmesh.connection.OpenAiConnection;
import cc.unitmesh.openai.OpenAiProvider;
import cc.unitmesh.prompt.model.Job;
import cc.unitmesh.prompt.validate.Validator;
import com.charleskorn.kaml.PolymorphismStyle;
import com.charleskorn.kaml.Yaml;
import com.charleskorn.kaml.YamlConfiguration;
import java.io.File;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.datetime.Clock;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.StringFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u001a\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H&J \u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0007H\u0016R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0019"}, d2={"Lcc/unitmesh/prompt/executor/base/JobStrategyExecutor;", "", "basePath", "Ljava/nio/file/Path;", "getBasePath", "()Ljava/nio/file/Path;", "createFileName", "", "name", "createLlmProvider", "Lcc/unitmesh/cf/core/llms/LlmProvider;", "job", "Lcc/unitmesh/prompt/model/Job;", "temperature", "Ljava/math/BigDecimal;", "execute", "", "handleJobResult", "jobName", "llmResult", "initConnectionConfig", "Lcc/unitmesh/connection/ConnectionConfig;", "writeToFile", "resultFileName", "Companion", "prompt-script"})
public interface JobStrategyExecutor {
    @NotNull
    public static final Companion Companion = cc.unitmesh.prompt.executor.base.JobStrategyExecutor$Companion.$$INSTANCE;

    @NotNull
    public Path getBasePath();

    public void execute();

    @NotNull
    public LlmProvider createLlmProvider(@NotNull Job var1, @Nullable BigDecimal var2);

    public void handleJobResult(@NotNull String var1, @NotNull Job var2, @NotNull String var3);

    public void writeToFile(@NotNull String var1, @NotNull String var2);

    @NotNull
    public String createFileName(@NotNull String var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcc/unitmesh/prompt/executor/base/JobStrategyExecutor$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "prompt-script"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Logger log;

        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        static {
            $$INSTANCE = new Companion();
            Logger logger = LoggerFactory.getLogger(JobStrategyExecutor.class);
            Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
            log = logger;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nJobStrategyExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JobStrategyExecutor.kt\ncc/unitmesh/prompt/executor/base/JobStrategyExecutor$DefaultImpls\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,87:1\n1855#2,2:88\n123#3:90\n*S KotlinDebug\n*F\n+ 1 JobStrategyExecutor.kt\ncc/unitmesh/prompt/executor/base/JobStrategyExecutor$DefaultImpls\n*L\n46#1:88,2\n84#1:90\n*E\n"})
    public static final class DefaultImpls {
        @NotNull
        public static LlmProvider createLlmProvider(@NotNull JobStrategyExecutor $this, @NotNull Job job, @Nullable BigDecimal temperature) {
            LlmProvider llmProvider;
            Intrinsics.checkNotNullParameter(job, "job");
            ConnectionConfig connection = DefaultImpls.initConnectionConfig($this, job);
            if (connection instanceof OpenAiConnection) {
                OpenAiProvider provider = new OpenAiProvider(((OpenAiConnection)connection).getApiKey(), ((OpenAiConnection)connection).getApiHost());
                if (temperature != null) {
                    provider.setTemperature(temperature.doubleValue());
                }
                llmProvider = provider;
            } else if (connection instanceof MockLlmConnection) {
                llmProvider = new MockLlmProvider(((MockLlmConnection)connection).getResponse());
            } else {
                throw new Exception("unsupported connection type: " + connection.getType());
            }
            LlmProvider llmProvider2 = llmProvider;
            return llmProvider2;
        }

        public static void handleJobResult(@NotNull JobStrategyExecutor $this, @NotNull String jobName, @NotNull Job job, @NotNull String llmResult) {
            Intrinsics.checkNotNullParameter(jobName, "jobName");
            Intrinsics.checkNotNullParameter(job, "job");
            Intrinsics.checkNotNullParameter(llmResult, "llmResult");
            Companion.getLog().debug("execute job: " + jobName);
            List<Validator> validators = job.buildValidators(llmResult);
            Iterable $this$forEach$iv = validators;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Validator it = (Validator)element$iv;
                boolean bl = false;
                boolean isSuccess = it.validate();
                String simpleName2 = it.getClass().getSimpleName();
                if (!isSuccess) {
                    Companion.getLog().error(simpleName2 + " validate failed: " + it.getInput());
                    continue;
                }
                Companion.getLog().debug(simpleName2 + " validate success: " + it.getInput());
            }
            String resultFileName = $this.createFileName(jobName);
            $this.writeToFile(resultFileName, llmResult);
        }

        public static void writeToFile(@NotNull JobStrategyExecutor $this, @NotNull String resultFileName, @NotNull String llmResult) {
            Intrinsics.checkNotNullParameter(resultFileName, "resultFileName");
            Intrinsics.checkNotNullParameter(llmResult, "llmResult");
            File resultFile = $this.getBasePath().resolve(resultFileName).toFile();
            Path relativePath = $this.getBasePath().relativize(resultFile.toPath());
            Companion.getLog().info("write result to file: " + relativePath);
            Intrinsics.checkNotNull(resultFile);
            FilesKt.writeText$default(resultFile, llmResult, null, 2, null);
        }

        @NotNull
        public static String createFileName(@NotNull JobStrategyExecutor $this, @NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            Instant currentMoment = Clock.System.INSTANCE.now();
            LocalDateTime datetimeInUtc = TimeZoneKt.toLocalDateTime(currentMoment, TimeZone.Companion.getUTC());
            String timeStr = StringsKt.replace$default(datetimeInUtc.toString(), ":", "-", false, 4, null);
            String jobName = StringsKt.replace$default(name, " ", "-", false, 4, null);
            return jobName + "-" + timeStr + ".txt";
        }

        private static ConnectionConfig initConnectionConfig(JobStrategyExecutor $this, Job job) {
            File connectionFile = $this.getBasePath().resolve(job.getConnection()).toFile();
            Companion.getLog().info("connection file: " + connectionFile.getAbsolutePath());
            Intrinsics.checkNotNull(connectionFile);
            String text = new String(FilesKt.readBytes(connectionFile), Charsets.UTF_8);
            YamlConfiguration configuration = new YamlConfiguration(false, false, null, PolymorphismStyle.Property, null, 0, 0, null, null, null, null, 0, false, null, 16375, null);
            StringFormat $this$decodeFromString$iv = new Yaml(null, configuration, 1, null);
            boolean $i$f$decodeFromString = false;
            $this$decodeFromString$iv.getSerializersModule();
            ConnectionConfig connection = (ConnectionConfig)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)ConnectionConfig.Companion.serializer(), text);
            return connection.convert();
        }
    }
}

