/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.prompt.executor.base;

import cc.unitmesh.cf.core.llms.LlmMsg;
import cc.unitmesh.cf.core.llms.LlmProvider;
import cc.unitmesh.prompt.executor.base.JobStrategyExecutor;
import cc.unitmesh.prompt.executor.base.SingleJobExecuteStrategy;
import cc.unitmesh.prompt.model.Job;
import cc.unitmesh.prompt.template.TemplateDataCompile;
import cc.unitmesh.template.TemplateEngineType;
import cc.unitmesh.template.TemplateRoleSplitter;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcc/unitmesh/prompt/executor/base/SingleJobExecuteStrategy;", "Lcc/unitmesh/prompt/executor/base/JobStrategyExecutor;", "jobName", "", "job", "Lcc/unitmesh/prompt/model/Job;", "basePath", "Ljava/nio/file/Path;", "(Ljava/lang/String;Lcc/unitmesh/prompt/model/Job;Ljava/nio/file/Path;)V", "getBasePath", "()Ljava/nio/file/Path;", "getJob", "()Lcc/unitmesh/prompt/model/Job;", "getJobName", "()Ljava/lang/String;", "execSingleJob", "name", "temperature", "Ljava/math/BigDecimal;", "renderSingleJobTemplate", "Companion", "prompt-script"})
public abstract class SingleJobExecuteStrategy
implements JobStrategyExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String jobName;
    @NotNull
    private final Job job;
    @NotNull
    private final Path basePath;
    @NotNull
    private static final Logger log;

    public SingleJobExecuteStrategy(@NotNull String jobName, @NotNull Job job, @NotNull Path basePath) {
        Intrinsics.checkNotNullParameter(jobName, "jobName");
        Intrinsics.checkNotNullParameter(job, "job");
        Intrinsics.checkNotNullParameter(basePath, "basePath");
        this.jobName = jobName;
        this.job = job;
        this.basePath = basePath;
    }

    @NotNull
    public String getJobName() {
        return this.jobName;
    }

    @NotNull
    public Job getJob() {
        return this.job;
    }

    @Override
    @NotNull
    public Path getBasePath() {
        return this.basePath;
    }

    @NotNull
    public final String execSingleJob(@NotNull String name, @NotNull Job job, @Nullable BigDecimal temperature) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(job, "job");
        LlmProvider llmProvider = this.createLlmProvider(job, temperature);
        String prompt2 = this.renderSingleJobTemplate(job);
        Map<String, String> msgs = new TemplateRoleSplitter().split(prompt2);
        List<LlmMsg.ChatMessage> messages = LlmMsg.Companion.fromMap(msgs);
        if (messages.isEmpty()) {
            throw new Exception("no messages found in template");
        }
        String resultFileName = this.createFileName("prompt-log");
        Path logbasePath = Path.of(job.getLogPath(), new String[0]);
        if (!logbasePath.toFile().exists()) {
            logbasePath.toFile().mkdirs();
        }
        Path resultFilePath = logbasePath.resolve(resultFileName);
        this.writeToFile(((Object)resultFilePath).toString(), CollectionsKt.joinToString$default(messages, "\n", null, null, 0, null, execSingleJob.1.INSTANCE, 30, null));
        log.info("save prompt to debug file: " + resultFilePath);
        return llmProvider.completion(messages);
    }

    public static /* synthetic */ String execSingleJob$default(SingleJobExecuteStrategy singleJobExecuteStrategy, String string, Job job, BigDecimal bigDecimal, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: execSingleJob");
        }
        if ((n & 4) != 0) {
            bigDecimal = null;
        }
        return singleJobExecuteStrategy.execSingleJob(string, job, bigDecimal);
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String renderSingleJobTemplate(@NotNull Job job) {
        block7: {
            Intrinsics.checkNotNullParameter(job, "job");
            var3_3 = ext = StringsKt.substringAfterLast$default(job.getTemplate(), ".", null, 2, null);
            switch (var3_3.hashCode()) {
                case 3767: {
                    if (!var3_3.equals("vm")) {
                        break;
                    }
                    ** GOTO lbl14
                }
                case 117071: {
                    if (!var3_3.equals("vsl")) {
                        break;
                    }
                    ** GOTO lbl14
                }
                case 3278: {
                    if (!var3_3.equals("ft")) break;
lbl14:
                    // 3 sources

                    factory = new TemplateDataCompile(TemplateEngineType.VELOCITY);
                    templatePath = this.getBasePath().resolve(job.getTemplate()).toString();
                    break block7;
                }
            }
            throw new Exception("unsupported template type: " + ext);
        }
        return factory.compile(templatePath, job.getTemplateDatasource(), this.getBasePath());
    }

    @Override
    @NotNull
    public String createFileName(@NotNull String name) {
        return JobStrategyExecutor.DefaultImpls.createFileName(this, name);
    }

    @Override
    @NotNull
    public LlmProvider createLlmProvider(@NotNull Job job, @Nullable BigDecimal temperature) {
        return JobStrategyExecutor.DefaultImpls.createLlmProvider(this, job, temperature);
    }

    @Override
    public void handleJobResult(@NotNull String jobName, @NotNull Job job, @NotNull String llmResult) {
        JobStrategyExecutor.DefaultImpls.handleJobResult(this, jobName, job, llmResult);
    }

    @Override
    public void writeToFile(@NotNull String resultFileName, @NotNull String llmResult) {
        JobStrategyExecutor.DefaultImpls.writeToFile(this, resultFileName, llmResult);
    }

    static {
        Logger logger = LoggerFactory.getLogger(SingleJobExecuteStrategy.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcc/unitmesh/prompt/executor/base/SingleJobExecuteStrategy$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "prompt-script"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

