/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.prompt.executor.strategy;

import cc.unitmesh.cf.core.llms.LlmMsg;
import cc.unitmesh.cf.core.llms.LlmProvider;
import cc.unitmesh.prompt.executor.ScriptExecutor;
import cc.unitmesh.prompt.executor.base.JobStrategyExecutor;
import cc.unitmesh.prompt.executor.strategy.DatasourceCollectionStrategy;
import cc.unitmesh.prompt.model.Job;
import cc.unitmesh.prompt.model.JobStrategy;
import cc.unitmesh.prompt.model.TemplateDatasource;
import cc.unitmesh.prompt.template.TemplateDataCompile;
import cc.unitmesh.template.TemplateEngineType;
import cc.unitmesh.template.TemplateRoleSplitter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.math.BigDecimal;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcc/unitmesh/prompt/executor/strategy/DatasourceCollectionStrategy;", "Lcc/unitmesh/prompt/executor/base/JobStrategyExecutor;", "job", "Lcc/unitmesh/prompt/model/Job;", "basePath", "Ljava/nio/file/Path;", "jobName", "", "collection", "Lcc/unitmesh/prompt/model/JobStrategy$DatasourceCollection;", "(Lcc/unitmesh/prompt/model/Job;Ljava/nio/file/Path;Ljava/lang/String;Lcc/unitmesh/prompt/model/JobStrategy$DatasourceCollection;)V", "getBasePath", "()Ljava/nio/file/Path;", "getJob", "()Lcc/unitmesh/prompt/model/Job;", "execJob", "item", "Lcom/google/gson/JsonElement;", "temperature", "Ljava/math/BigDecimal;", "execute", "", "loadCollection", "Lcom/google/gson/JsonArray;", "sources", "", "Lcc/unitmesh/prompt/model/TemplateDatasource;", "Companion", "prompt-script"})
@SourceDebugExtension(value={"SMAP\nDatasourceCollectionStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatasourceCollectionStrategy.kt\ncc/unitmesh/prompt/executor/strategy/DatasourceCollectionStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1855#2:114\n1855#2,2:115\n1856#2:117\n1855#2:118\n1855#2,2:119\n1856#2:121\n*S KotlinDebug\n*F\n+ 1 DatasourceCollectionStrategy.kt\ncc/unitmesh/prompt/executor/strategy/DatasourceCollectionStrategy\n*L\n31#1:114\n34#1:115,2\n31#1:117\n82#1:118\n96#1:119,2\n82#1:121\n*E\n"})
public final class DatasourceCollectionStrategy
implements JobStrategyExecutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Job job;
    @NotNull
    private final Path basePath;
    @NotNull
    private final String jobName;
    @NotNull
    private final JobStrategy.DatasourceCollection collection;
    @NotNull
    private static final Logger log;

    public DatasourceCollectionStrategy(@NotNull Job job, @NotNull Path basePath, @NotNull String jobName, @NotNull JobStrategy.DatasourceCollection collection) {
        Intrinsics.checkNotNullParameter(job, "job");
        Intrinsics.checkNotNullParameter(basePath, "basePath");
        Intrinsics.checkNotNullParameter(jobName, "jobName");
        Intrinsics.checkNotNullParameter(collection, "collection");
        this.job = job;
        this.basePath = basePath;
        this.jobName = jobName;
        this.collection = collection;
    }

    @NotNull
    public final Job getJob() {
        return this.job;
    }

    @Override
    @NotNull
    public Path getBasePath() {
        return this.basePath;
    }

    @Override
    public void execute() {
        JsonArray data2 = this.loadCollection(this.job.getTemplateDatasource());
        Iterable $this$forEach$iv = data2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonElement item = (JsonElement)element$iv;
            boolean bl = false;
            List<Map<String, String>> collection = this.collection.getValue();
            BigDecimal temperature = null;
            Iterable $this$forEach$iv2 = collection;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Map variable = (Map)element$iv2;
                boolean bl2 = false;
                if (!variable.containsKey("temperature")) continue;
                String string = (String)variable.get("temperature");
                temperature = string != null ? new BigDecimal(string) : null;
            }
            Intrinsics.checkNotNull(item);
            String llmResult = this.execJob(this.job, item, temperature);
            this.handleJobResult(this.jobName, this.job, llmResult);
        }
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final String execJob(@NotNull Job job, @NotNull JsonElement item, @Nullable BigDecimal temperature) {
        block9: {
            Intrinsics.checkNotNullParameter(job, "job");
            Intrinsics.checkNotNullParameter(item, "item");
            llmProvider = this.createLlmProvider(job, temperature);
            var7_6 = ext = StringsKt.substringAfterLast$default(job.getTemplate(), ".", null, 2, null);
            switch (var7_6.hashCode()) {
                case 3767: {
                    if (!var7_6.equals("vm")) {
                        break;
                    }
                    ** GOTO lbl16
                }
                case 117071: {
                    if (!var7_6.equals("vsl")) {
                        break;
                    }
                    ** GOTO lbl16
                }
                case 3278: {
                    if (!var7_6.equals("ft")) break;
lbl16:
                    // 3 sources

                    factory = new TemplateDataCompile(TemplateEngineType.VELOCITY);
                    templatePath = this.getBasePath().resolve(job.getTemplate()).toString();
                    break block9;
                }
            }
            throw new Exception("unsupported template type: " + ext);
        }
        prompt = factory.compile(templatePath, item);
        msgs = new TemplateRoleSplitter().split(prompt);
        messages = LlmMsg.Companion.fromMap(msgs);
        if (messages.isEmpty()) {
            throw new Exception("no messages found in template");
        }
        resultFileName = this.createFileName("prompt-log");
        logbasePath = Path.of(job.getLogPath(), new String[0]);
        if (!logbasePath.toFile().exists()) {
            logbasePath.toFile().mkdirs();
        }
        resultFilePath = logbasePath.resolve(resultFileName);
        this.writeToFile(resultFilePath.toString(), CollectionsKt.joinToString$default(messages, "\n", null, null, 0, null, execJob.1.INSTANCE, 30, null));
        DatasourceCollectionStrategy.log.info("save prompt to debug file: " + resultFilePath);
        return llmProvider.completion(messages);
    }

    public static /* synthetic */ String execJob$default(DatasourceCollectionStrategy datasourceCollectionStrategy, Job job, JsonElement jsonElement, BigDecimal bigDecimal, int n, Object object) {
        if ((n & 4) != 0) {
            bigDecimal = null;
        }
        return datasourceCollectionStrategy.execJob(job, jsonElement, bigDecimal);
    }

    private final JsonArray loadCollection(List<? extends TemplateDatasource> sources) {
        JsonArray results = new JsonArray();
        Iterable $this$forEach$iv = sources;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String ext;
            TemplateDatasource datasource = (TemplateDatasource)element$iv;
            boolean bl = false;
            if (!(datasource instanceof TemplateDatasource.File)) continue;
            File file2 = this.getBasePath().resolve(((TemplateDatasource.File)datasource).getValue()).toFile();
            Intrinsics.checkNotNull(file2);
            String text = FilesKt.readText(file2, Charsets.UTF_8);
            String string = ext = FilesKt.getExtension(file2);
            if (Intrinsics.areEqual(string, "json")) {
                JsonObject obj = JsonParser.parseString(text).getAsJsonObject();
                results.add(obj);
                continue;
            }
            if (Intrinsics.areEqual(string, "jsonl")) {
                String[] stringArray = new String[]{"\n"};
                List lines = StringsKt.split$default((CharSequence)text, stringArray, false, 0, 6, null);
                Iterable $this$forEach$iv2 = lines;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    String line = (String)element$iv2;
                    boolean bl2 = false;
                    JsonObject obj = JsonParser.parseString(line).getAsJsonObject();
                    results.add(obj);
                }
                continue;
            }
            ScriptExecutor.Companion.getLog().error("unsupported datasource file: " + file2.getAbsolutePath());
        }
        return results;
    }

    @Override
    @NotNull
    public String createFileName(@NotNull String name) {
        return JobStrategyExecutor.DefaultImpls.createFileName(this, name);
    }

    @Override
    @NotNull
    public LlmProvider createLlmProvider(@NotNull Job job, @Nullable BigDecimal temperature) {
        return JobStrategyExecutor.DefaultImpls.createLlmProvider(this, job, temperature);
    }

    @Override
    public void handleJobResult(@NotNull String jobName, @NotNull Job job, @NotNull String llmResult) {
        JobStrategyExecutor.DefaultImpls.handleJobResult(this, jobName, job, llmResult);
    }

    @Override
    public void writeToFile(@NotNull String resultFileName, @NotNull String llmResult) {
        JobStrategyExecutor.DefaultImpls.writeToFile(this, resultFileName, llmResult);
    }

    static {
        Logger logger = LoggerFactory.getLogger(DatasourceCollectionStrategy.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcc/unitmesh/prompt/executor/strategy/DatasourceCollectionStrategy$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "prompt-script"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

