/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.prompt.validate;

import cc.unitmesh.prompt.validate.AccessType;
import cc.unitmesh.prompt.validate.CompareExpr;
import cc.unitmesh.prompt.validate.CompareType;
import cc.unitmesh.prompt.validate.PropertyAccess;
import cc.unitmesh.prompt.validate.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcc/unitmesh/prompt/validate/StringValidator;", "Lcc/unitmesh/prompt/validate/Validator;", "expression", "", "input", "(Ljava/lang/String;Ljava/lang/String;)V", "getExpression", "()Ljava/lang/String;", "getInput", "parseExpression", "Lcc/unitmesh/prompt/validate/CompareExpr;", "parsePropertyAccess", "Lcc/unitmesh/prompt/validate/PropertyAccess;", "validate", "", "prompt-script"})
public final class StringValidator
implements Validator {
    @NotNull
    private final String expression;
    @NotNull
    private final String input;

    public StringValidator(@NotNull String expression, @NotNull String input) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(input, "input");
        this.expression = expression;
        this.input = input;
    }

    @NotNull
    public final String getExpression() {
        return this.expression;
    }

    @Override
    @NotNull
    public String getInput() {
        return this.input;
    }

    @Override
    public boolean validate() {
        boolean bl;
        CompareExpr expr = this.parseExpression(this.expression);
        String left = expr.getLeft();
        String right = expr.getRight();
        CompareType operator = expr.getOperator();
        block0 : switch (WhenMappings.$EnumSwitchMapping$1[operator.ordinal()]) {
            case 1: {
                bl = Intrinsics.areEqual(this.getInput(), right);
                break;
            }
            case 2: {
                if (!Intrinsics.areEqual(this.getInput(), right)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                bl = StringsKt.contains$default((CharSequence)this.getInput(), right, false, 2, null);
                break;
            }
            case 4: {
                bl = StringsKt.startsWith$default(this.getInput(), right, false, 2, null);
                break;
            }
            case 5: {
                bl = StringsKt.endsWith$default(this.getInput(), right, false, 2, null);
                break;
            }
            case 6: {
                if (this.getInput().length() > Integer.parseInt(right)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 7: {
                if (this.getInput().length() < Integer.parseInt(right)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 8: {
                PropertyAccess propertyAccess = this.parsePropertyAccess(left);
                switch (WhenMappings.$EnumSwitchMapping$0[propertyAccess.getOperator().ordinal()]) {
                    case 1: {
                        if (this.getInput().length() == Integer.parseInt(right)) {
                            bl = true;
                            break block0;
                        }
                        bl = false;
                        break block0;
                    }
                    case 2: {
                        String string = this.getInput().toUpperCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toUpperCase(Locale.ROOT)");
                        bl = Intrinsics.areEqual(string, right);
                        break block0;
                    }
                    case 3: {
                        String string = this.getInput().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                        bl = Intrinsics.areEqual(string, right);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    private final CompareExpr parseExpression(String expression) {
        CompareType compareType;
        char[] cArray = expression.toCharArray();
        Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
        char[] chars = cArray;
        List tokens = new ArrayList();
        StringBuilder sb = new StringBuilder();
        boolean isInQuote = false;
        for (char c : chars) {
            if (c == '\"' || c == '\'') {
                isInQuote = !isInQuote;
                continue;
            }
            if (isInQuote) {
                sb.append(c);
                continue;
            }
            if (c == ' ') {
                if (!(((CharSequence)sb).length() > 0)) continue;
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                tokens.add(string);
                StringsKt.clear(sb);
                continue;
            }
            sb.append(c);
        }
        if (((CharSequence)sb).length() > 0) {
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            tokens.add(string);
        }
        String left = (String)tokens.get(0);
        switch ((String)tokens.get(1)) {
            case "==": {
                compareType = CompareType.EQUALS;
                break;
            }
            case "!=": {
                compareType = CompareType.NOT_EQUALS;
                break;
            }
            case "contains": {
                compareType = CompareType.CONTAINS;
                break;
            }
            case "startsWith": {
                compareType = CompareType.STARTS_WITH;
                break;
            }
            case "endsWith": {
                compareType = CompareType.ENDS_WITH;
                break;
            }
            case "length": {
                compareType = CompareType.PROPERTY_ACCESS;
                break;
            }
            case "uppercase": {
                compareType = CompareType.PROPERTY_ACCESS;
                break;
            }
            case "lowercase": {
                compareType = CompareType.PROPERTY_ACCESS;
                break;
            }
            case ">": {
                compareType = CompareType.GREATER_THAN;
                break;
            }
            case "<": {
                compareType = CompareType.LESS_THAN;
                break;
            }
            default: {
                throw new Exception("Unsupported operator " + tokens.get(1));
            }
        }
        CompareType operator = compareType;
        String right = (String)tokens.get(2);
        if (StringsKt.startsWith$default(right, "\"", false, 2, null) && StringsKt.endsWith$default(right, "\"", false, 2, null)) {
            String string = right.substring(1, right.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            return new CompareExpr(left, operator, string);
        }
        return new CompareExpr(left, operator, right);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final PropertyAccess parsePropertyAccess(String expression) {
        AccessType accessType;
        String propertyName;
        List tokens;
        block10: {
            block9: {
                char[] cArray = expression.toCharArray();
                Intrinsics.checkNotNullExpressionValue(cArray, "this as java.lang.String).toCharArray()");
                char[] chars = cArray;
                tokens = new ArrayList();
                StringBuilder sb = new StringBuilder();
                for (char c : chars) {
                    if (c == '.') {
                        if (!(((CharSequence)sb).length() > 0)) continue;
                        String string = sb.toString();
                        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                        tokens.add(string);
                        StringsKt.clear(sb);
                        continue;
                    }
                    sb.append(c);
                }
                if (((CharSequence)sb).length() > 0) {
                    String string = sb.toString();
                    Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                    tokens.add(string);
                }
                propertyName = (String)tokens.get(0);
                String c = (String)tokens.get(1);
                switch (c.hashCode()) {
                    case 223523538: {
                        if (c.equals("uppercase")) break;
                        throw new Exception("Unsupported operator " + tokens.get(1));
                    }
                    case -514507343: {
                        if (!c.equals("lowercase")) {
                            throw new Exception("Unsupported operator " + tokens.get(1));
                        }
                        break block9;
                    }
                    case -1106363674: {
                        if (!c.equals("length")) throw new Exception("Unsupported operator " + tokens.get(1));
                        accessType = AccessType.LENGTH;
                        break block10;
                    }
                }
                accessType = AccessType.UPPER_CASE;
                break block10;
            }
            accessType = AccessType.LOWER_CASE;
            break block10;
            throw new Exception("Unsupported operator " + tokens.get(1));
        }
        AccessType operator = accessType;
        String value = (String)tokens.get(2);
        return new PropertyAccess(propertyName, operator, value);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[AccessType.values().length];
            try {
                nArray[AccessType.LENGTH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccessType.UPPER_CASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AccessType.LOWER_CASE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CompareType.values().length];
            try {
                nArray[CompareType.EQUALS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompareType.NOT_EQUALS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompareType.CONTAINS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompareType.STARTS_WITH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompareType.ENDS_WITH.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompareType.GREATER_THAN.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompareType.LESS_THAN.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompareType.PROPERTY_ACCESS.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

