/*
 * Decompiled with CFR 0.152.
 */
package cc.unitmesh.rag.loader;

import cc.unitmesh.rag.document.Document;
import cc.unitmesh.rag.loader.Loader;
import cc.unitmesh.rag.splitter.TextSplitter;
import cc.unitmesh.rag.splitter.TokenTextSplitter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00052\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\r0\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcc/unitmesh/rag/loader/JsonLoader;", "Lcc/unitmesh/rag/loader/Loader;", "inputStream", "Ljava/io/InputStream;", "jsonKeysToUse", "", "", "(Ljava/io/InputStream;Ljava/util/List;)V", "load", "Lcc/unitmesh/rag/document/Document;", "textSplitter", "Lcc/unitmesh/rag/splitter/TextSplitter;", "jsonData", "", "", "cocoa-core"})
public final class JsonLoader
implements Loader {
    @NotNull
    private final InputStream inputStream;
    @NotNull
    private List<String> jsonKeysToUse;

    public JsonLoader(@NotNull InputStream inputStream2, @NotNull List<String> jsonKeysToUse) {
        Intrinsics.checkNotNullParameter(inputStream2, "inputStream");
        Intrinsics.checkNotNullParameter(jsonKeysToUse, "jsonKeysToUse");
        this.inputStream = inputStream2;
        this.jsonKeysToUse = jsonKeysToUse;
    }

    public /* synthetic */ JsonLoader(InputStream inputStream2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(inputStream2, list);
    }

    @Override
    @NotNull
    public List<Document> load() {
        return this.load(new TokenTextSplitter(null, 0, 0, 0, 0, 31, null));
    }

    @Override
    @NotNull
    public List<Document> load(@NotNull TextSplitter textSplitter) {
        Intrinsics.checkNotNullParameter(textSplitter, "textSplitter");
        ObjectMapper objectMapper = new ObjectMapper();
        List<Document> documents = null;
        try {
            Object t = objectMapper.readValue(this.inputStream, (TypeReference)new TypeReference<List<? extends Map<String, ? extends Object>>>(){});
            Intrinsics.checkNotNullExpressionValue(t, "readValue(...)");
            List jsonData2 = (List)t;
            documents = this.load(jsonData2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return textSplitter.apply(documents);
    }

    @NotNull
    public final List<Document> load(@NotNull List<? extends Map<String, ? extends Object>> jsonData2) {
        Intrinsics.checkNotNullParameter(jsonData2, "jsonData");
        List documents = new ArrayList();
        for (Map<String, ? extends Object> map2 : jsonData2) {
            Document document;
            StringBuilder sb = new StringBuilder();
            for (String key : this.jsonKeysToUse) {
                if (!map2.containsKey(key)) continue;
                sb.append(key);
                sb.append(": ");
                sb.append(map2.get(key));
                sb.append(System.lineSeparator());
            }
            if (((CharSequence)sb).length() > 0) {
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
                document = new Document(string, null, 2, null);
                documents.add(document);
                continue;
            }
            document = new Document(map2.toString(), null, 2, null);
            documents.add(document);
        }
        return documents;
    }
}

