/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.util.OptionHelper;

public class StatusListenerConfigHelper {
    public static void installIfAsked(Context context2) {
        String slClass = OptionHelper.getSystemProperty("logback.statusListenerClass");
        if (!OptionHelper.isNullOrEmpty(slClass)) {
            StatusListenerConfigHelper.addStatusListener(context2, slClass);
        }
    }

    private static void addStatusListener(Context context2, String listenerClassName) {
        StatusListener listener = null;
        listener = "SYSOUT".equalsIgnoreCase(listenerClassName) || "STDOUT".equalsIgnoreCase(listenerClassName) ? new OnConsoleStatusListener() : StatusListenerConfigHelper.createListenerPerClassName(context2, listenerClassName);
        StatusListenerConfigHelper.initAndAddListener(context2, listener);
    }

    private static void initAndAddListener(Context context2, StatusListener listener) {
        if (listener != null) {
            boolean effectivelyAdded;
            if (listener instanceof ContextAware) {
                ((ContextAware)((Object)listener)).setContext(context2);
            }
            if ((effectivelyAdded = context2.getStatusManager().add(listener)) && listener instanceof LifeCycle) {
                ((LifeCycle)((Object)listener)).start();
            }
        }
    }

    private static StatusListener createListenerPerClassName(Context context2, String listenerClass) {
        try {
            return (StatusListener)OptionHelper.instantiateByClassName(listenerClass, StatusListener.class, context2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void addOnConsoleListenerInstance(Context context2, OnConsoleStatusListener onConsoleStatusListener) {
        onConsoleStatusListener.setContext(context2);
        boolean effectivelyAdded = context2.getStatusManager().add(onConsoleStatusListener);
        if (effectivelyAdded) {
            onConsoleStatusListener.start();
        }
    }
}

