/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.jsonSchema;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.module.jsonSchema.JsonSchemaIdResolver;
import com.fasterxml.jackson.module.jsonSchema.types.AnySchema;
import com.fasterxml.jackson.module.jsonSchema.types.ArraySchema;
import com.fasterxml.jackson.module.jsonSchema.types.BooleanSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ContainerTypeSchema;
import com.fasterxml.jackson.module.jsonSchema.types.IntegerSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NullSchema;
import com.fasterxml.jackson.module.jsonSchema.types.NumberSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ObjectSchema;
import com.fasterxml.jackson.module.jsonSchema.types.SimpleTypeSchema;
import com.fasterxml.jackson.module.jsonSchema.types.StringSchema;
import com.fasterxml.jackson.module.jsonSchema.types.UnionTypeSchema;
import com.fasterxml.jackson.module.jsonSchema.types.ValueTypeSchema;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonTypeInfo(use=JsonTypeInfo.Id.CUSTOM, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonTypeIdResolver(value=JsonSchemaIdResolver.class)
public abstract class JsonSchema {
    @JsonProperty
    private String id;
    @JsonProperty
    private String $ref;
    @JsonProperty
    private String $schema;
    @JsonProperty
    private JsonSchema[] disallow;
    private JsonSchema[] extendsextends;
    @JsonProperty
    private Boolean required = null;
    @JsonProperty
    private Boolean readonly = null;
    private String description;

    protected JsonSchema() {
    }

    public AnySchema asAnySchema() {
        return null;
    }

    public ArraySchema asArraySchema() {
        return null;
    }

    public BooleanSchema asBooleanSchema() {
        return null;
    }

    @Deprecated
    public ContainerTypeSchema asContainerSchema() {
        return this.asContainerTypeSchema();
    }

    public ContainerTypeSchema asContainerTypeSchema() {
        return null;
    }

    public IntegerSchema asIntegerSchema() {
        return null;
    }

    public NullSchema asNullSchema() {
        return null;
    }

    public NumberSchema asNumberSchema() {
        return null;
    }

    public ObjectSchema asObjectSchema() {
        return null;
    }

    public SimpleTypeSchema asSimpleTypeSchema() {
        return null;
    }

    public StringSchema asStringSchema() {
        return null;
    }

    public UnionTypeSchema asUnionTypeSchema() {
        return null;
    }

    @Deprecated
    public ValueTypeSchema asValueSchemaSchema() {
        return this.asValueTypeSchema();
    }

    public ValueTypeSchema asValueTypeSchema() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String get$ref() {
        return this.$ref;
    }

    public String get$schema() {
        return this.$schema;
    }

    public JsonSchema[] getDisallow() {
        return this.disallow;
    }

    public JsonSchema[] getExtends() {
        return this.extendsextends;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Boolean getReadonly() {
        return this.readonly;
    }

    public String getDescription() {
        return this.description;
    }

    @JsonIgnore
    public abstract JsonFormatTypes getType();

    @JsonIgnore
    public boolean isAnySchema() {
        return false;
    }

    @JsonIgnore
    public boolean isArraySchema() {
        return false;
    }

    @JsonIgnore
    public boolean isBooleanSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isContainerTypeSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isIntegerSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isNullSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isNumberSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isObjectSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isSimpleTypeSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isStringSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isUnionTypeSchema() {
        return false;
    }

    @JsonIgnore
    public boolean isValueTypeSchema() {
        return false;
    }

    public void set$ref(String $ref) {
        this.$ref = $ref;
    }

    public void set$schema(String $schema) {
        this.$schema = $schema;
    }

    public void setDisallow(JsonSchema[] disallow) {
        this.disallow = disallow;
    }

    public void setExtends(JsonSchema[] extendsextends) {
        this.extendsextends = extendsextends;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setRequired(Boolean required2) {
        this.required = required2;
    }

    public void setReadonly(Boolean readonly) {
        this.readonly = readonly;
    }

    public void setDescription(String description2) {
        this.description = description2;
    }

    public void enrichWithBeanProperty(BeanProperty beanProperty) {
        this.setDescription(beanProperty.getMetadata().getDescription());
    }

    public static JsonSchema minimalForFormat(JsonFormatTypes format2) {
        if (format2 != null) {
            switch (format2) {
                case ARRAY: {
                    return new ArraySchema();
                }
                case OBJECT: {
                    return new ObjectSchema();
                }
                case BOOLEAN: {
                    return new BooleanSchema();
                }
                case INTEGER: {
                    return new IntegerSchema();
                }
                case NUMBER: {
                    return new NumberSchema();
                }
                case STRING: {
                    return new StringSchema();
                }
                case NULL: {
                    return new NullSchema();
                }
            }
        }
        return new AnySchema();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JsonSchema)) {
            return false;
        }
        return this._equals((JsonSchema)obj);
    }

    protected boolean _equals(JsonSchema that) {
        return JsonSchema.equals(this.getId(), that.getId()) && JsonSchema.equals(this.getRequired(), that.getRequired()) && JsonSchema.equals(this.getReadonly(), that.getReadonly()) && JsonSchema.equals(this.get$ref(), that.get$ref()) && JsonSchema.equals(this.get$schema(), that.get$schema()) && JsonSchema.arraysEqual(this.getDisallow(), that.getDisallow()) && JsonSchema.arraysEqual(this.getExtends(), that.getExtends());
    }

    protected static boolean equals(Object object1, Object object2) {
        if (object1 == null) {
            return object2 == null;
        }
        return object1.equals(object2);
    }

    protected static <T> boolean arraysEqual(T[] arr1, T[] arr2) {
        if (arr1 == null) {
            return arr2 == null;
        }
        if (arr2 == null) {
            return false;
        }
        int len = arr1.length;
        if (len != arr2.length) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (JsonSchema.equals(arr1[i], arr2[i])) continue;
            return false;
        }
        return true;
    }
}

