/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.transform;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.transform.EasingFunction;
import com.github.ajalt.colormath.transform.EasingFunctions;
import com.github.ajalt.colormath.transform.HueAdjustments;
import com.github.ajalt.colormath.transform.InterpolateKt;
import com.github.ajalt.colormath.transform.InterpolationMethod;
import com.github.ajalt.colormath.transform.InterpolationMethods;
import com.github.ajalt.colormath.transform.Interpolator;
import com.github.ajalt.colormath.transform.InterpolatorBuilder;
import com.github.ajalt.colormath.transform.InterpolatorImpl;
import com.github.ajalt.colormath.transform.InterpolatorStopBuilder;
import com.github.ajalt.colormath.transform.InterpolatorStopBuilderImpl;
import com.github.ajalt.colormath.transform.Stop;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001;B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010'\u001a\u00020(2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020)0\u000bH\u0002J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020)0\u000bH\u0002J\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,JC\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020\t21\u0010/\u001a-\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nj\u0002`\u0010H\u0016J\u0018\u00100\u001a\u00020(2\u0006\u0010.\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u00101\u001a\u00020(H\u0002J\b\u00102\u001a\u00020(H\u0002J\b\u00103\u001a\u00020(H\u0002J-\u00104\u001a\u00020(2\u0006\u00105\u001a\u00020\u00022\u001b\u00106\u001a\u0017\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020(0\nj\u0002`8\u00a2\u0006\u0002\b9H\u0016J5\u00104\u001a\u00020(2\u0006\u00105\u001a\u00020\u00022\u0006\u0010:\u001a\u00020\f2\u001b\u00106\u001a\u0017\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020(0\nj\u0002`8\u00a2\u0006\u0002\b9H\u0016RE\u0010\u0007\u001a9\u0012\u0004\u0012\u00020\t\u0012/\u0012-\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nj\u0002`\u00100\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00120\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/github/ajalt/colormath/transform/InterpolatorBuilderImpl;", "T", "Lcom/github/ajalt/colormath/Color;", "Lcom/github/ajalt/colormath/transform/InterpolatorBuilder;", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "(Lcom/github/ajalt/colormath/ColorSpace;)V", "adjustments", "", "", "Lkotlin/Function1;", "", "", "Lkotlin/ParameterName;", "name", "hues", "Lcom/github/ajalt/colormath/transform/ComponentAdjustment;", "easing", "Lcom/github/ajalt/colormath/transform/EasingFunction;", "getEasing", "()Lcom/github/ajalt/colormath/transform/EasingFunction;", "setEasing", "(Lcom/github/ajalt/colormath/transform/EasingFunction;)V", "easingFns", "entries", "", "Lcom/github/ajalt/colormath/transform/InterpolatorBuilderImpl$Entry;", "method", "Lcom/github/ajalt/colormath/transform/InterpolationMethod;", "getMethod", "()Lcom/github/ajalt/colormath/transform/InterpolationMethod;", "setMethod", "(Lcom/github/ajalt/colormath/transform/InterpolationMethod;)V", "premultiplyAlpha", "", "getPremultiplyAlpha", "()Z", "setPremultiplyAlpha", "(Z)V", "applyAdjustments", "", "Lcom/github/ajalt/colormath/transform/Stop;", "bakeComponents", "build", "Lcom/github/ajalt/colormath/transform/Interpolator;", "componentAdjustment", "component", "adjustment", "componentEasing", "fixupDecreasingPos", "fixupEndpoints", "fixupMissingPos", "stop", "color", "builder", "Lcom/github/ajalt/colormath/transform/InterpolatorStopBuilder;", "Lcom/github/ajalt/colormath/transform/InterpolatorStopBuilderContext;", "Lkotlin/ExtensionFunctionType;", "position", "Entry", "colormath"})
@SourceDebugExtension(value={"SMAP\nInterpolate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Interpolate.kt\ncom/github/ajalt/colormath/transform/InterpolatorBuilderImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,402:1\n766#2:403\n857#2,2:404\n1855#2,2:406\n1559#2:408\n1590#2,3:409\n1549#2:412\n1620#2,3:413\n1593#2:416\n1549#2:417\n1620#2,3:418\n1549#2:421\n1620#2,3:422\n1549#2:425\n1620#2,3:426\n1864#2,3:429\n*S KotlinDebug\n*F\n+ 1 Interpolate.kt\ncom/github/ajalt/colormath/transform/InterpolatorBuilderImpl\n*L\n246#1:403\n246#1:404,2\n246#1:406,2\n275#1:408\n275#1:409,3\n276#1:412\n276#1:413,3\n275#1:416\n279#1:417\n279#1:418,3\n330#1:421\n330#1:422,3\n338#1:425\n338#1:426,3\n338#1:429,3\n*E\n"})
final class InterpolatorBuilderImpl<T extends Color>
implements InterpolatorBuilder {
    @NotNull
    private final ColorSpace<T> space;
    private boolean premultiplyAlpha;
    @NotNull
    private InterpolationMethod method;
    @NotNull
    private EasingFunction easing;
    @NotNull
    private final List<Entry> entries;
    @NotNull
    private final Map<String, EasingFunction> easingFns;
    @NotNull
    private final Map<String, Function1<List<Float>, List<Float>>> adjustments;

    /*
     * WARNING - void declaration
     */
    public InterpolatorBuilderImpl(@NotNull ColorSpace<T> space) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(space, "space");
        this.space = space;
        this.premultiplyAlpha = true;
        this.method = InterpolationMethods.INSTANCE.linear();
        this.easing = EasingFunctions.INSTANCE.linear();
        this.entries = new ArrayList();
        this.easingFns = new LinkedHashMap();
        Object object = new Pair[]{TuplesKt.to("alpha", InterpolateKt.access$getAlphaAdjustment$p())};
        Object object2 = object = MapsKt.mutableMapOf(object);
        InterpolatorBuilderImpl interpolatorBuilderImpl = this;
        boolean bl = false;
        Iterable $this$filter$iv = this.space.getComponents();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ColorComponentInfo it = (ColorComponentInfo)element$iv$iv;
            boolean bl2 = false;
            if (!it.isPolar()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$adjustments_u24lambda_u242;
            ColorComponentInfo it = (ColorComponentInfo)element$iv;
            boolean bl3 = false;
            String string = it.getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            $this$adjustments_u24lambda_u242.put(string, HueAdjustments.INSTANCE.getShorter());
        }
        interpolatorBuilderImpl.adjustments = object;
    }

    @Override
    public boolean getPremultiplyAlpha() {
        return this.premultiplyAlpha;
    }

    @Override
    public void setPremultiplyAlpha(boolean bl) {
        this.premultiplyAlpha = bl;
    }

    @Override
    @NotNull
    public InterpolationMethod getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(@NotNull InterpolationMethod interpolationMethod) {
        Intrinsics.checkNotNullParameter(interpolationMethod, "<set-?>");
        this.method = interpolationMethod;
    }

    @Override
    @NotNull
    public EasingFunction getEasing() {
        return this.easing;
    }

    @Override
    public void setEasing(@NotNull EasingFunction easingFunction) {
        Intrinsics.checkNotNullParameter(easingFunction, "<set-?>");
        this.easing = easingFunction;
    }

    @Override
    public void componentAdjustment(@NotNull String component, @NotNull Function1<? super List<Float>, ? extends List<Float>> adjustment) {
        Intrinsics.checkNotNullParameter(component, "component");
        Intrinsics.checkNotNullParameter(adjustment, "adjustment");
        this.adjustments.put(InterpolateKt.access$requireComponentName(this.space, component), adjustment);
    }

    @Override
    public void componentEasing(@NotNull String component, @NotNull EasingFunction easing) {
        Intrinsics.checkNotNullParameter(component, "component");
        Intrinsics.checkNotNullParameter(easing, "easing");
        this.easingFns.put(InterpolateKt.access$requireComponentName(this.space, component), easing);
    }

    @Override
    public void stop(@NotNull Color color, @NotNull Function1<? super InterpolatorStopBuilder, Unit> builder2) {
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Collection collection = this.entries;
        InterpolatorStopBuilderImpl interpolatorStopBuilderImpl = new InterpolatorStopBuilderImpl(this.space);
        builder2.invoke(interpolatorStopBuilderImpl);
        collection.add(new Entry(color, null, interpolatorStopBuilderImpl));
    }

    @Override
    public void stop(@NotNull Color color, float position, @NotNull Function1<? super InterpolatorStopBuilder, Unit> builder2) {
        Intrinsics.checkNotNullParameter(color, "color");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Collection collection = this.entries;
        Float f = Float.valueOf(position);
        InterpolatorStopBuilderImpl interpolatorStopBuilderImpl = new InterpolatorStopBuilderImpl(this.space);
        builder2.invoke(interpolatorStopBuilderImpl);
        collection.add(new Entry(color, f, interpolatorStopBuilderImpl));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Interpolator<T> build() {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapIndexedTo$iv$iv;
        this.fixupEndpoints();
        this.fixupDecreasingPos();
        this.fixupMissingPos();
        List<Stop> out2 = this.bakeComponents();
        this.applyAdjustments(out2);
        Iterable $this$mapIndexed$iv = this.space.getComponents();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ColorComponentInfo cfr_ignored_0 = (ColorComponentInfo)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv;
            boolean bl = false;
            Iterable iterable2 = out2;
            InterpolationMethod interpolationMethod = this.getMethod();
            boolean $i$f$map = false;
            void var18_20 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void i;
                void it;
                Stop stop2 = (Stop)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(new InterpolationMethod.Point(it.getPos(), it.getComponents()[i]));
            }
            collection.add(interpolationMethod.build((List)destination$iv$iv2));
        }
        List lerps = (List)destination$iv$iv;
        Iterable $this$map$iv = this.entries;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Entry entry = (Entry)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            Float f = it.getPos();
            Intrinsics.checkNotNull(f);
            collection.add(new InterpolatorImpl.Easing(f.floatValue(), it.getBuilder().build(this.easingFns, this.getEasing())));
        }
        List fns = (List)destination$iv$iv3;
        return new InterpolatorImpl<T>(lerps, fns, this.space, this.getPremultiplyAlpha());
    }

    private final void fixupEndpoints() {
        Float f = this.entries.get(0).getPos();
        this.entries.set(0, Entry.copy$default(this.entries.get(0), null, Float.valueOf(f != null ? f.floatValue() : 0.0f), null, 5, null));
        Float f2 = CollectionsKt.last(this.entries).getPos();
        this.entries.set(CollectionsKt.getLastIndex(this.entries), Entry.copy$default(CollectionsKt.last(this.entries), null, Float.valueOf(f2 != null ? f2.floatValue() : 1.0f), null, 5, null));
    }

    private final void fixupDecreasingPos() {
        float pos = 0.0f;
        Iterator<Entry> iterator2 = this.entries.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            Entry entry = iterator2.next();
            Float f = entry.getPos();
            if (f == null) {
                continue;
            }
            float p = f.floatValue();
            if (p < pos) {
                this.entries.set(i, Entry.copy$default(entry, null, Float.valueOf(pos), null, 5, null));
            }
            pos = p;
        }
    }

    private final void fixupMissingPos() {
        int runStart = -1;
        int runLen = 0;
        Iterator<Entry> iterator2 = this.entries.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            Entry entry = iterator2.next();
            if (entry.getPos() == null) {
                if (runStart < 0) {
                    runStart = i;
                }
                ++runLen;
                continue;
            }
            if (runLen <= 0) continue;
            Float f = this.entries.get(runStart - 1).getPos();
            Intrinsics.checkNotNull(f);
            float prevPos = f.floatValue();
            Float nextPos = entry.getPos();
            int fixed = 0;
            for (int j = runStart; j < i; ++j) {
                this.entries.set(j, Entry.copy$default(this.entries.get(j), null, Float.valueOf(InterpolateKt.access$lerp(prevPos, nextPos.floatValue(), (float)(1 + fixed) / (float)(1 + runLen))), null, 5, null));
                ++fixed;
            }
            runStart = -1;
            runLen = 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Stop> bakeComponents() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.entries;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Entry entry = (Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Color c = entry.component1();
            Float p = entry.component2();
            float[] fArray = InterpolateKt.access$mult(this.space, this.getPremultiplyAlpha(), this.space.convert(c).toArray());
            Float f = p;
            Intrinsics.checkNotNull(f);
            collection.add(new Stop(fArray, f.floatValue()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyAdjustments(List<Stop> entries2) {
        Iterator<ColorComponentInfo> iterator2 = this.space.getComponents().iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Function1<List<Float>, List<Float>> adj;
            int i = n++;
            ColorComponentInfo component = iterator2.next();
            String string = component.getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
            if (this.adjustments.get(string) == null) continue;
            Iterable iterable = entries2;
            Function1<List<Float>, List<Float>> function1 = adj;
            boolean $i$f$map = false;
            void var9_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Stop stop2 = (Stop)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Float.valueOf(it.getComponents()[i]));
            }
            Iterable $this$forEachIndexed$iv = function1.invoke((List)destination$iv$iv);
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void new_;
                int n2;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                float item$iv$iv = ((Number)item$iv).floatValue();
                int j = n2;
                boolean bl = false;
                entries2.get((int)j).getComponents()[i] = new_;
            }
        }
    }

    @Override
    public void stop(@NotNull Color color, double position, @NotNull Function1<? super InterpolatorStopBuilder, Unit> builder2) {
        InterpolatorBuilder.DefaultImpls.stop(this, color, position, builder2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J.\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/github/ajalt/colormath/transform/InterpolatorBuilderImpl$Entry;", "", "color", "Lcom/github/ajalt/colormath/Color;", "pos", "", "builder", "Lcom/github/ajalt/colormath/transform/InterpolatorStopBuilderImpl;", "(Lcom/github/ajalt/colormath/Color;Ljava/lang/Float;Lcom/github/ajalt/colormath/transform/InterpolatorStopBuilderImpl;)V", "getBuilder", "()Lcom/github/ajalt/colormath/transform/InterpolatorStopBuilderImpl;", "getColor", "()Lcom/github/ajalt/colormath/Color;", "getPos", "()Ljava/lang/Float;", "Ljava/lang/Float;", "component1", "component2", "component3", "copy", "(Lcom/github/ajalt/colormath/Color;Ljava/lang/Float;Lcom/github/ajalt/colormath/transform/InterpolatorStopBuilderImpl;)Lcom/github/ajalt/colormath/transform/InterpolatorBuilderImpl$Entry;", "equals", "", "other", "hashCode", "", "toString", "", "colormath"})
    private static final class Entry {
        @NotNull
        private final Color color;
        @Nullable
        private final Float pos;
        @NotNull
        private final InterpolatorStopBuilderImpl builder;

        public Entry(@NotNull Color color, @Nullable Float pos, @NotNull InterpolatorStopBuilderImpl builder2) {
            Intrinsics.checkNotNullParameter(color, "color");
            Intrinsics.checkNotNullParameter(builder2, "builder");
            this.color = color;
            this.pos = pos;
            this.builder = builder2;
        }

        @NotNull
        public final Color getColor() {
            return this.color;
        }

        @Nullable
        public final Float getPos() {
            return this.pos;
        }

        @NotNull
        public final InterpolatorStopBuilderImpl getBuilder() {
            return this.builder;
        }

        @NotNull
        public final Color component1() {
            return this.color;
        }

        @Nullable
        public final Float component2() {
            return this.pos;
        }

        @NotNull
        public final InterpolatorStopBuilderImpl component3() {
            return this.builder;
        }

        @NotNull
        public final Entry copy(@NotNull Color color, @Nullable Float pos, @NotNull InterpolatorStopBuilderImpl builder2) {
            Intrinsics.checkNotNullParameter(color, "color");
            Intrinsics.checkNotNullParameter(builder2, "builder");
            return new Entry(color, pos, builder2);
        }

        public static /* synthetic */ Entry copy$default(Entry entry, Color color, Float f, InterpolatorStopBuilderImpl interpolatorStopBuilderImpl, int n, Object object) {
            if ((n & 1) != 0) {
                color = entry.color;
            }
            if ((n & 2) != 0) {
                f = entry.pos;
            }
            if ((n & 4) != 0) {
                interpolatorStopBuilderImpl = entry.builder;
            }
            return entry.copy(color, f, interpolatorStopBuilderImpl);
        }

        @NotNull
        public String toString() {
            return "Entry(color=" + this.color + ", pos=" + this.pos + ", builder=" + this.builder + ')';
        }

        public int hashCode() {
            int result2 = this.color.hashCode();
            result2 = result2 * 31 + (this.pos == null ? 0 : ((Object)this.pos).hashCode());
            result2 = result2 * 31 + this.builder.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)other;
            if (!Intrinsics.areEqual(this.color, entry.color)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pos, (Object)entry.pos)) {
                return false;
            }
            return Intrinsics.areEqual(this.builder, entry.builder);
        }
    }
}

