/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.transform;

import com.github.ajalt.colormath.transform.InterpolationMethod;
import com.github.ajalt.colormath.transform.InterpolationMethodKt;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/github/ajalt/colormath/transform/LinearInterpolator;", "Lcom/github/ajalt/colormath/transform/InterpolationMethod$ComponentInterpolator;", "points", "", "Lcom/github/ajalt/colormath/transform/InterpolationMethod$Point;", "(Ljava/util/List;)V", "interpolate", "", "t", "colormath"})
@SourceDebugExtension(value={"SMAP\nInterpolationMethod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterpolationMethod.kt\ncom/github/ajalt/colormath/transform/LinearInterpolator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,157:1\n1#2:158\n378#3,7:159\n*S KotlinDebug\n*F\n+ 1 InterpolationMethod.kt\ncom/github/ajalt/colormath/transform/LinearInterpolator\n*L\n70#1:159,7\n*E\n"})
final class LinearInterpolator
implements InterpolationMethod.ComponentInterpolator {
    @NotNull
    private final List<InterpolationMethod.Point> points;

    public LinearInterpolator(@NotNull List<InterpolationMethod.Point> points) {
        Intrinsics.checkNotNullParameter(points, "points");
        this.points = points;
        if (!(this.points.size() > 1)) {
            boolean bl = false;
            String string = "At least two points are required for interpolation";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public float interpolate(float t) {
        int start2;
        block3: {
            int n;
            List<InterpolationMethod.Point> $this$indexOfLast$iv = this.points;
            boolean $i$f$indexOfLast = false;
            ListIterator<InterpolationMethod.Point> iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                InterpolationMethod.Point it = iterator$iv.previous();
                boolean bl = false;
                if (!(it.getX() <= t)) continue;
                n = iterator$iv.nextIndex();
                break block3;
            }
            n = start2 = -1;
        }
        if (start2 < 0) {
            return CollectionsKt.first(this.points).getY();
        }
        if (this.points.get(start2).getX() == t || start2 == CollectionsKt.getLastIndex(this.points)) {
            return this.points.get(start2).getY();
        }
        int end = start2 + 1;
        InterpolationMethod.Point point = this.points.get(start2);
        float lx = point.component1();
        float ly = point.component2();
        InterpolationMethod.Point point2 = this.points.get(end);
        float rx = point2.component1();
        float ry = point2.component2();
        return InterpolationMethodKt.access$lerp(ly, ry, (t - lx) / (rx - lx));
    }
}

