/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.mordant.internal.FallbackMppImpls;
import com.github.ajalt.mordant.internal.JvmTerminalCursor;
import com.github.ajalt.mordant.internal.MppImpls;
import com.github.ajalt.mordant.internal.jna.JnaLinuxMppImpls;
import com.github.ajalt.mordant.internal.jna.JnaMacosMppImpls;
import com.github.ajalt.mordant.internal.jna.JnaWin32MppImpls;
import com.github.ajalt.mordant.internal.nativeimage.NativeImagePosixMppImpls;
import com.github.ajalt.mordant.internal.nativeimage.NativeImageWin32MppImpls;
import com.github.ajalt.mordant.terminal.PrintRequest;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.terminal.TerminalCursor;
import com.github.ajalt.mordant.terminal.TerminalInterceptor;
import com.github.ajalt.mordant.terminal.TerminalInterface;
import java.io.Console;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Collection;
import java.util.List;
import java.util.PrimitiveIterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.ConsoleKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000`\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0000\u001a\u0016\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\nH\u0000\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u0013H\u0000\u001a\b\u0010\u0016\u001a\u00020\u0013H\u0000\u001a&\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0000\u001a\b\u0010\u001f\u001a\u00020\u0013H\u0000\u001a\b\u0010 \u001a\u00020\u0013H\u0000\u001a\"\u0010!\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00100%H\u0080\b\u00f8\u0001\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006&"}, d2={"impls", "Lcom/github/ajalt/mordant/internal/MppImpls;", "codepointSequence", "Lkotlin/sequences/Sequence;", "", "string", "", "getEnv", "key", "getTerminalSize", "Lkotlin/Pair;", "makePrintingTerminalCursor", "Lcom/github/ajalt/mordant/terminal/TerminalCursor;", "terminal", "Lcom/github/ajalt/mordant/terminal/Terminal;", "printStderr", "", "message", "newline", "", "readLineOrNullMpp", "hideInput", "runningInIdeaJavaAgent", "sendInterceptedPrintRequest", "request", "Lcom/github/ajalt/mordant/terminal/PrintRequest;", "terminalInterface", "Lcom/github/ajalt/mordant/terminal/TerminalInterface;", "interceptors", "", "Lcom/github/ajalt/mordant/terminal/TerminalInterceptor;", "stdinInteractive", "stdoutInteractive", "synchronizeJvm", "lock", "", "block", "Lkotlin/Function0;", "mordant"})
@SourceDebugExtension(value={"SMAP\nMppImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MppImpl.kt\ncom/github/ajalt/mordant/internal/MppImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1747#2,3:121\n1789#2,3:124\n*S KotlinDebug\n*F\n+ 1 MppImpl.kt\ncom/github/ajalt/mordant/internal/MppImplKt\n*L\n33#1:121,3\n94#1:124,3\n*E\n"})
public final class MppImplKt {
    @NotNull
    private static final MppImpls impls;

    @Nullable
    public static final String getEnv(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return System.getenv(key);
    }

    public static final boolean runningInIdeaJavaAgent() {
        boolean bl;
        try {
            boolean bl2;
            block5: {
                RuntimeMXBean bean = ManagementFactory.getRuntimeMXBean();
                List<String> jvmArgs = bean.getInputArguments();
                Intrinsics.checkNotNull(jvmArgs);
                Iterable $this$any$iv = jvmArgs;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        Intrinsics.checkNotNull(it);
                        if (!(StringsKt.startsWith$default(it, "-javaagent", false, 2, null) && StringsKt.contains$default((CharSequence)it, "idea_rt.jar", false, 2, null))) continue;
                        bl2 = true;
                        break block5;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        }
        catch (SecurityException e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public static final Sequence<Integer> codepointSequence(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "string");
        PrimitiveIterator.OfInt ofInt2 = string.codePoints().iterator();
        Intrinsics.checkNotNullExpressionValue(ofInt2, "iterator(...)");
        return SequencesKt.asSequence(ofInt2);
    }

    public static final void printStderr(@NotNull String message, boolean newline) {
        Intrinsics.checkNotNullParameter(message, "message");
        if (newline) {
            System.err.println(message);
        } else {
            System.err.print(message);
        }
    }

    @Nullable
    public static final String readLineOrNullMpp(boolean hideInput) {
        Console console;
        if (hideInput && (console = System.console()) != null) {
            char[] cArray = console.readPassword();
            Intrinsics.checkNotNullExpressionValue(cArray, "readPassword(...)");
            return StringsKt.concatToString(cArray);
        }
        return ConsoleKt.readlnOrNull();
    }

    @NotNull
    public static final TerminalCursor makePrintingTerminalCursor(@NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter(terminal, "terminal");
        return new JvmTerminalCursor(terminal);
    }

    /*
     * WARNING - void declaration
     */
    public static final void sendInterceptedPrintRequest(@NotNull PrintRequest request, @NotNull TerminalInterface terminalInterface, @NotNull List<? extends TerminalInterceptor> interceptors) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(request, "request");
        Intrinsics.checkNotNullParameter(terminalInterface, "terminalInterface");
        Intrinsics.checkNotNullParameter(interceptors, "interceptors");
        Iterable iterable = interceptors;
        TerminalInterface terminalInterface2 = terminalInterface;
        boolean $i$f$fold = false;
        PrintRequest accumulator$iv = request;
        for (Object element$iv : $this$fold$iv) {
            void it;
            TerminalInterceptor terminalInterceptor = (TerminalInterceptor)element$iv;
            PrintRequest acc = accumulator$iv;
            boolean bl = false;
            accumulator$iv = it.intercept(acc);
        }
        terminalInterface2.completePrintRequest(accumulator$iv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void synchronizeJvm(@NotNull Object lock, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter(lock, "lock");
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$synchronizeJvm = false;
        Object object = lock;
        synchronized (object) {
            try {
                Unit unit = block.invoke();
            }
            finally {
                InlineMarker.finallyStart(1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                InlineMarker.finallyEnd(1);
            }
            return;
        }
    }

    public static final boolean stdoutInteractive() {
        return impls.stdoutInteractive();
    }

    public static final boolean stdinInteractive() {
        return impls.stdinInteractive();
    }

    @Nullable
    public static final Pair<Integer, Integer> getTerminalSize() {
        return impls.getTerminalSize();
    }

    /*
     * Unable to fully structure code
     */
    static {
        os = System.getProperty("os.name");
        $i$a$-let-MppImplKt$impls$1 = false;
        try {
            imageCode = System.getProperty("org.graalvm.nativeimage.imagecode");
            isNativeImage = Intrinsics.areEqual(imageCode, "buildtime") != false || Intrinsics.areEqual(imageCode, "runtime") != false;
            if (!isNativeImage) ** GOTO lbl-1000
            Intrinsics.checkNotNull(os);
            if (StringsKt.startsWith$default(os, "Windows", false, 2, null)) {
                v0 = new NativeImageWin32MppImpls();
            } else if (isNativeImage && (Intrinsics.areEqual(os, "Linux") || Intrinsics.areEqual(os, "Mac OS X"))) {
                v0 = new NativeImagePosixMppImpls();
            } else {
                Intrinsics.checkNotNull(os);
                v0 = StringsKt.startsWith$default(os, "Windows", false, 2, null) != false ? (MppImpls)new JnaWin32MppImpls() : (Intrinsics.areEqual(os, "Linux") != false ? (MppImpls)new JnaLinuxMppImpls() : (Intrinsics.areEqual(os, "Mac OS X") != false ? (MppImpls)new JnaMacosMppImpls() : (MppImpls)new FallbackMppImpls()));
            }
            var2_2 = v0;
        }
        catch (UnsatisfiedLinkError e) {
            var2_2 = new FallbackMppImpls();
        }
        MppImplKt.impls = var2_2;
    }
}

