/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.internal;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.RGBColorSpace;
import com.github.ajalt.mordant.internal.AnsiCodes;
import com.github.ajalt.mordant.internal.Chunk;
import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.rendering.Line;
import com.github.ajalt.mordant.rendering.Lines;
import com.github.ajalt.mordant.rendering.Span;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyleKt;
import com.github.ajalt.mordant.rendering.TxtStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u001a,\u0010\u0003\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0002\u001a\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\t2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000b0\tH\u0002\u001a\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002\u001a \u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\rH\u0000\u001a \u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a \u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"LS", "", "NEL", "getAnsiColor", "Lkotlin/Pair;", "Lcom/github/ajalt/colormath/Color;", "", "i", "codes", "", "parseAnsi", "Lcom/github/ajalt/mordant/internal/Chunk;", "text", "", "defaultStyle", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "parseText", "Lcom/github/ajalt/mordant/rendering/Lines;", "splitLines", "Lcom/github/ajalt/mordant/rendering/Line;", "words", "splitWords", "chunk", "updateStyle", "existingStyle", "ansi", "updateStyleWithCsi", "updateStyleWithOsc", "mordant"})
@SourceDebugExtension(value={"SMAP\nParsing.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parsing.kt\ncom/github/ajalt/mordant/internal/ParsingKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,252:1\n1360#2:253\n1446#2,5:254\n1603#2,9:260\n1855#2:269\n1856#2:271\n1612#2:272\n1#3:259\n1#3:270\n*S KotlinDebug\n*F\n+ 1 Parsing.kt\ncom/github/ajalt/mordant/internal/ParsingKt\n*L\n22#1:253\n22#1:254,5\n133#1:260,9\n133#1:269\n133#1:271\n133#1:272\n133#1:270\n*E\n"})
public final class ParsingKt {
    private static final char NEL = '\u0085';
    private static final char LS = '\u2028';

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Lines parseText(@NotNull String text, @NotNull TextStyle defaultStyle) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(defaultStyle, "defaultStyle");
        List<Chunk> parseAnsi = ParsingKt.parseAnsi(text, defaultStyle);
        Iterable $this$flatMap$iv = parseAnsi;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Chunk it = (Chunk)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ParsingKt.splitWords(it);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List<Chunk> words2 = CollectionsKt.toList((List)destination$iv$iv);
        List<Line> splitLines = ParsingKt.splitLines(words2);
        return new Lines(splitLines);
    }

    private static final List<Chunk> parseAnsi(String text, TextStyle defaultStyle) {
        List<MatchResult> commands = SequencesKt.toList(Regex.findAll$default(ConstantsKt.getANSI_RE(), text, 0, 2, null));
        if (commands.isEmpty()) {
            return CollectionsKt.listOf(new Chunk(text, defaultStyle));
        }
        List parts = new ArrayList();
        int idxAfterLastCmd = 0;
        TextStyle style = defaultStyle;
        for (MatchResult command2 : commands) {
            if (command2.getRange().getFirst() > idxAfterLastCmd) {
                Collection collection = parts;
                String string = text.substring(idxAfterLastCmd, command2.getRange().getFirst());
                Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                collection.add(new Chunk(string, style));
            }
            idxAfterLastCmd = command2.getRange().getLast() + 1;
            style = ParsingKt.updateStyle(style, defaultStyle, command2.getValue());
        }
        if (idxAfterLastCmd < text.length()) {
            Collection collection = parts;
            String string = text.substring(idxAfterLastCmd);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
            collection.add(new Chunk(string, style));
        }
        return parts;
    }

    private static final List<Chunk> splitWords(Chunk chunk) {
        int i;
        List chunks = new ArrayList();
        int start2 = 0;
        int chunkType = -1;
        String t = chunk.getText();
        for (i = 0; i < t.length(); ++i) {
            int type2;
            char c = t.charAt(i);
            int n = c == '\r' ? 0 : (c == '\n' || c == '\t' || c == '\u0085' || c == '\u2028' ? 1 : (type2 = CharsKt.isWhitespace(c) ? 2 : 3));
            if (i == 0) {
                chunkType = type2;
                continue;
            }
            if (type2 != 1 && chunkType == type2) continue;
            Collection collection = chunks;
            String string = t.substring(start2, i);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            collection.add(Chunk.copy$default(chunk, string, null, 2, null));
            start2 = i;
            chunkType = type2;
        }
        if (start2 != i) {
            Collection collection = chunks;
            String string = t.substring(start2, i);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            collection.add(Chunk.copy$default(chunk, string, null, 2, null));
        }
        return chunks;
    }

    private static final List<Line> splitLines(List<Chunk> words2) {
        List lines;
        block4: {
            lines = new ArrayList();
            List line = new ArrayList();
            for (Chunk word : words2) {
                if (StringsKt.endsWith$default(word.getText(), "\n", false, 2, null)) {
                    ((Collection)lines).add(new Line(line, word.getStyle()));
                    line = new ArrayList();
                    continue;
                }
                line.add(Span.Companion.word(word.getText(), word.getStyle()));
            }
            if (!((Collection)line).isEmpty()) {
                ((Collection)lines).add(new Line(line));
            }
            Chunk chunk = CollectionsKt.lastOrNull(words2);
            if (chunk == null) break block4;
            Chunk it = chunk;
            boolean bl = false;
            if (StringsKt.endsWith$default(it.getText(), "\n", false, 2, null)) {
                lines.add(new Line(CollectionsKt.emptyList(), it.getStyle()));
            }
        }
        return lines;
    }

    @NotNull
    public static final TextStyle updateStyle(@NotNull TextStyle existingStyle, @NotNull TextStyle defaultStyle, @NotNull String ansi) {
        Intrinsics.checkNotNullParameter(existingStyle, "existingStyle");
        Intrinsics.checkNotNullParameter(defaultStyle, "defaultStyle");
        Intrinsics.checkNotNullParameter(ansi, "ansi");
        if (StringsKt.startsWith$default(ansi, "\u001b]", false, 2, null)) {
            return ParsingKt.updateStyleWithOsc(ansi, existingStyle, defaultStyle);
        }
        if (StringsKt.startsWith$default(ansi, "\u001b[", false, 2, null)) {
            return ParsingKt.updateStyleWithCsi(ansi, existingStyle, defaultStyle);
        }
        return existingStyle;
    }

    private static final TextStyle updateStyleWithOsc(String ansi, TextStyle existingStyle, TextStyle defaultStyle) {
        String string;
        String id;
        String string2;
        if (!StringsKt.startsWith$default(ansi, "\u001b]8", false, 2, null)) {
            return existingStyle;
        }
        String string3 = ansi.substring(3, ansi.length() - 2);
        Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
        String[] stringArray = new String[]{";"};
        List params = StringsKt.split$default((CharSequence)string3, stringArray, false, 0, 6, null);
        if (params.isEmpty()) {
            return existingStyle;
        }
        Object t = CollectionsKt.last(params);
        String it = (String)t;
        boolean bl = false;
        String hyperlink = (String)(!StringsKt.isBlank(it) ? t : null);
        if (hyperlink == null) {
            string2 = defaultStyle.getHyperlinkId();
        } else {
            Object v2;
            block6: {
                Iterable iterable = params;
                for (Object t2 : iterable) {
                    String it2 = (String)t2;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default(it2, "id=", false, 2, null)) continue;
                    v2 = t2;
                    break block6;
                }
                v2 = null;
            }
            String string4 = v2;
            string2 = id = string4 != null ? StringsKt.drop(string4, 3) : null;
        }
        if ((string = hyperlink) == null) {
            string = defaultStyle.getHyperlink();
        }
        return TextStyleKt.copy$default(existingStyle, null, null, string, id, 3, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final TextStyle updateStyleWithCsi(String ansi, TextStyle existingStyle, TextStyle defaultStyle) {
        void $this$mapNotNullTo$iv$iv;
        if (!StringsKt.endsWith$default(ansi, "m", false, 2, null)) {
            return existingStyle;
        }
        String[] stringArray = new String[]{";"};
        Iterable $this$mapNotNull$iv = StringsKt.split$default(ansi.subSequence(2, ansi.length() - 1), stringArray, false, 0, 6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Integer it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if ((((CharSequence)it).length() == 0 ? Integer.valueOf(0) : StringsKt.toIntOrNull(it)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List codes = (List)destination$iv$iv;
        if (codes.isEmpty()) {
            return defaultStyle;
        }
        Color color = existingStyle.getColor();
        Color bgColor = existingStyle.getBgColor();
        Boolean bold = existingStyle.getBold();
        Boolean italic = existingStyle.getItalic();
        Boolean underline = existingStyle.getUnderline();
        Boolean dim = existingStyle.getDim();
        Boolean inverse = existingStyle.getInverse();
        Boolean strikethrough = existingStyle.getStrikethrough();
        for (int i = 0; i <= CollectionsKt.getLastIndex(codes); ++i) {
            int n;
            int consumed;
            boolean bl;
            boolean bl4;
            int code = ((Number)codes.get(i)).intValue();
            if (code == 0) {
                Boolean bl5;
                Boolean bl6;
                Boolean bl7;
                Boolean bl8;
                Boolean bl9;
                color = defaultStyle.getColor();
                bgColor = defaultStyle.getBgColor();
                Boolean bl10 = defaultStyle.getBold();
                if (bl10 == null) {
                    bl10 = bold = Boolean.valueOf(false);
                }
                if ((bl9 = defaultStyle.getItalic()) == null) {
                    bl9 = italic = Boolean.valueOf(false);
                }
                if ((bl8 = defaultStyle.getUnderline()) == null) {
                    bl8 = underline = Boolean.valueOf(false);
                }
                if ((bl7 = defaultStyle.getDim()) == null) {
                    bl7 = dim = Boolean.valueOf(false);
                }
                if ((bl6 = defaultStyle.getInverse()) == null) {
                    bl6 = inverse = Boolean.valueOf(false);
                }
                if ((bl5 = defaultStyle.getStrikethrough()) == null) {
                    bl5 = false;
                }
                strikethrough = bl5;
                continue;
            }
            if (code == 22) {
                Boolean bl11;
                Boolean bl12 = defaultStyle.getBold();
                if (bl12 == null) {
                    bl12 = bold = Boolean.valueOf(false);
                }
                if ((bl11 = defaultStyle.getDim()) == null) {
                    bl11 = false;
                }
                dim = bl11;
                continue;
            }
            if (code == 23) {
                Boolean bl13 = defaultStyle.getItalic();
                if (bl13 == null) {
                    bl13 = false;
                }
                italic = bl13;
                continue;
            }
            if (code == 24) {
                Boolean bl14 = defaultStyle.getUnderline();
                if (bl14 == null) {
                    bl14 = false;
                }
                underline = bl14;
                continue;
            }
            if (code == 27) {
                Boolean bl15 = defaultStyle.getInverse();
                if (bl15 == null) {
                    bl15 = false;
                }
                inverse = bl15;
                continue;
            }
            if (code == 29) {
                Boolean bl16 = defaultStyle.getStrikethrough();
                if (bl16 == null) {
                    bl16 = false;
                }
                strikethrough = bl16;
                continue;
            }
            if (code == 39) {
                color = defaultStyle.getColor();
                continue;
            }
            if (code == 49) {
                bgColor = defaultStyle.getBgColor();
                continue;
            }
            Pair<Color, Integer> pair2 = AnsiCodes.INSTANCE.getFg16Range();
            int it = ((IntProgression)((Object)pair2)).getFirst();
            boolean bl17 = code <= ((IntProgression)((Object)pair2)).getLast() ? it <= code : false;
            if (bl17) {
                bl4 = true;
            } else {
                pair2 = AnsiCodes.INSTANCE.getFg16BrightRange();
                it = ((IntProgression)((Object)pair2)).getFirst();
                bl4 = code <= ((IntProgression)((Object)pair2)).getLast() ? it <= code : false;
            }
            if (bl4) {
                color = new Ansi16(code);
                continue;
            }
            pair2 = AnsiCodes.INSTANCE.getBg16Range();
            it = ((IntProgression)((Object)pair2)).getFirst();
            boolean bl18 = code <= ((IntProgression)((Object)pair2)).getLast() ? it <= code : false;
            if (bl18) {
                bl = true;
            } else {
                pair2 = AnsiCodes.INSTANCE.getBg16BrightRange();
                it = ((IntProgression)((Object)pair2)).getFirst();
                bl = code <= ((IntProgression)((Object)pair2)).getLast() ? it <= code : false;
            }
            if (bl) {
                bgColor = new Ansi16(code - 10);
                continue;
            }
            if (code == 38) {
                pair2 = ParsingKt.getAnsiColor(i + 1, codes);
                Color c = (Color)pair2.component1();
                consumed = ((Number)pair2.component2()).intValue();
                if (c == null) break;
                color = c;
                i += consumed;
                continue;
            }
            if (code == 48) {
                pair2 = ParsingKt.getAnsiColor(i + 1, codes);
                Color c = pair2.component1();
                consumed = ((Number)pair2.component2()).intValue();
                if (c == null) break;
                bgColor = c;
                i += consumed;
                continue;
            }
            if (code == 1) {
                bold = true;
                continue;
            }
            if (code == 3) {
                italic = true;
                continue;
            }
            if (code == 4) {
                underline = true;
                continue;
            }
            if (code == 2) {
                dim = true;
                continue;
            }
            if (code == 7) {
                inverse = true;
                continue;
            }
            if (code == 9) {
                strikethrough = true;
                continue;
            }
            if (code != 58) continue;
            if (i == CollectionsKt.getLastIndex(codes)) {
                n = 0;
            } else {
                Integer n2 = (Integer)CollectionsKt.getOrNull(codes, i + 1);
                int n3 = 5;
                if (n2 != null && n2 == n3) {
                    n = 1;
                } else {
                    Integer n4 = (Integer)CollectionsKt.getOrNull(codes, i + 1);
                    n3 = 2;
                    if (n4 == null || n4 != n3) break;
                    n = 3;
                }
            }
            i = i + n;
        }
        return new TxtStyle(color, bgColor, bold, italic, underline, dim, inverse, strikethrough, existingStyle.getHyperlink(), existingStyle.getHyperlinkId());
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final Pair<Color, Integer> getAnsiColor(int i, List<Integer> codes) {
        Pair<Object, Integer> pair2;
        switch (((Number)codes.get(i)).intValue()) {
            case 5: {
                if (i + 1 <= CollectionsKt.getLastIndex(codes)) {
                    int n = ((Number)codes.get(i + 1)).intValue();
                    boolean bl = 0 <= n ? n < 256 : false;
                    if (bl) {
                        pair2 = TuplesKt.to(new Ansi256(((Number)codes.get(i + 1)).intValue()), 2);
                        return pair2;
                    }
                }
                pair2 = TuplesKt.to(null, 0);
                return pair2;
            }
            case 2: {
                if (i + 3 <= CollectionsKt.getLastIndex(codes)) {
                    int n = ((Number)codes.get(i + 1)).intValue();
                    boolean bl = 0 <= n ? n < 256 : false;
                    if (bl) {
                        n = ((Number)codes.get(i + 2)).intValue();
                        boolean bl2 = 0 <= n ? n < 256 : false;
                        if (bl2) {
                            n = ((Number)codes.get(i + 3)).intValue();
                            boolean bl3 = 0 <= n ? n < 256 : false;
                            if (bl3) {
                                pair2 = TuplesKt.to(RGBColorSpace.DefaultImpls.from255$default(RGB.Companion, ((Number)codes.get(i + 1)).intValue(), ((Number)codes.get(i + 2)).intValue(), ((Number)codes.get(i + 3)).intValue(), 0, 8, null), 4);
                                return pair2;
                            }
                        }
                    }
                }
                pair2 = TuplesKt.to(null, 0);
                return pair2;
            }
        }
        pair2 = TuplesKt.to(null, 0);
        return pair2;
    }
}

